package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dto.AppletRecordStatisDTO;
import com.pcloud.book.applet.entity.AppletRecordStatis;
import com.pcloud.book.applet.dao.AppletRecordStatisDao;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * 小睿小程序点击量统计(AppletRecordStatis)表数据库访问层
 *
 * @author makejava
 * @since 2020-12-10 17:58:06
 */
@Repository("appletRecordStatisDaoImpl")
public class AppletRecordStatisDaoImpl extends BaseDaoImpl<AppletRecordStatis> implements AppletRecordStatisDao {
    @Override
    public List<AppletRecordStatisDTO> getBookSourceWeekStatis(Long wechatUserId, Date mondayDate){
        HashMap<String,Object> paramMap = new HashMap<>();
        paramMap.put("wechatUserId",wechatUserId);
        paramMap.put("statisDate",mondayDate);
        return this.sqlSessionTemplate.selectList(getStatement("getBookSourceWeekStatis"),paramMap);
    }

    @Override
    public Integer getBookSourceTotalClickCount(Long wechatUserId, Date mondayDate) {
        HashMap<String,Object> paramMap = new HashMap<>();
        paramMap.put("wechatUserId",wechatUserId);
        paramMap.put("statisDate",mondayDate);
        return this.sqlSessionTemplate.selectOne(getStatement("getBookSourceTotalClickCount"),paramMap);
    }

    @Override
    public List<AppletRecordStatisDTO> getBookNewsWeekStatics(Long wechatUserId, Date mondayDate) {
        HashMap<String,Object> paramMap = new HashMap<>();
        paramMap.put("wechatUserId",wechatUserId);
        paramMap.put("statisDate",mondayDate);
        return this.sqlSessionTemplate.selectList(getStatement("getBookNewsWeekStatics"),paramMap);
    }

    @Override
    public Integer getBookNewsTotalClickCount(Long wechatUserId, Date mondayDate) {
        HashMap<String,Object> paramMap = new HashMap<>();
        paramMap.put("wechatUserId",wechatUserId);
        paramMap.put("statisDate",mondayDate);
        return this.sqlSessionTemplate.selectOne(getStatement("getBookNewsTotalClickCount"),paramMap);
    }

    @Override
    public void addWeekAppletRecordStatis4App(Date prevMonday, Date prevSunday, Long limitStart, Long limitNumber) {
        HashMap<String,Object> paramMap = new HashMap<>();
        paramMap.put("prevMonday", prevMonday);
        paramMap.put("prevSunday", prevSunday);
        paramMap.put("limitStart", limitStart);
        paramMap.put("limitNumber", limitNumber);
        this.sqlSessionTemplate.insert(getStatement("addWeekAppletRecordStatis4App"), paramMap);
    }

    @Override
    public void addWeekAppletRecordStatis4News(Date prevMonday, Date prevSunday, Long limitStart, Long limitNumber) {
        HashMap<String,Object> paramMap = new HashMap<>();
        paramMap.put("prevMonday", prevMonday);
        paramMap.put("prevSunday", prevSunday);
        paramMap.put("limitStart", limitStart);
        paramMap.put("limitNumber", limitNumber);
        this.sqlSessionTemplate.insert(getStatement("addWeekAppletRecordStatis4News"), paramMap);
    }

    @Override
    public void deleteWeekAppletRecordStatis(String monday) {
        HashMap<String,Object> paramMap = new HashMap<>();
        paramMap.put("monday", monday);
        this.sqlSessionTemplate.insert(getStatement("deleteWeekAppletRecordStatis"), paramMap);
    }
}
