package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletResourceApplyDao;
import com.pcloud.book.applet.entity.AppletResourceApply;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.applet.dao.impl.AppletResourceApplyDaoImpl
 * @Author zhuyajie
 * @Description
 * @Date 2021/5/8 14:46
 * @Version 1.0
 **/
@Component
public class AppletResourceApplyDaoImpl extends BaseDaoImpl<AppletResourceApply> implements AppletResourceApplyDao {
    @Override
    public void deleteCrowdType(Long targetId, String targetType) {
        Map<String, Object> map = new HashMap<>();
        map.put("targetId", targetId);
        map.put("targetType", targetType);
        getSessionTemplate().delete(getStatement("deleteCrowdType"), map);
    }

    @Override
    public void deleteContentType(Long targetId, String targetType) {
        Map<String, Object> map = new HashMap<>();
        map.put("targetId", targetId);
        map.put("targetType", targetType);
        getSessionTemplate().delete(getStatement("deleteContentType"), map);
    }

    @Override
    public List<Integer> getCrowdTypeList(Long targetId, String targetType) {
        Map<String, Object> map = new HashMap<>();
        map.put("targetId", targetId);
        map.put("targetType", targetType);
        return getSessionTemplate().selectList(getStatement("getCrowdTypeList"), map);
    }

    @Override
    public List<Integer> getContentTypeList(Long targetId, String targetType) {
        Map<String, Object> map = new HashMap<>();
        map.put("targetId", targetId);
        map.put("targetType", targetType);
        return getSessionTemplate().selectList(getStatement("getContentTypeList"), map);
    }
}
