package com.pcloud.book.applet.entity;

import com.pcloud.book.rightsSetting.entity.BaseTempletClassify;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

@Data
@ApiModel("小程序名片管理")
public class AppletBusinessCard extends BaseTempletClassify {

    private static final long serialVersionUID = 6564866177995663454L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("姓名")
    @NotNull(message = "姓名不能为空")
    private String name;

    @ApiModelProperty("头衔")
    @NotNull(message = "头衔不能为空")
    private String title;

    @ApiModelProperty("二维码")
    private String qrcode;

    @ApiModelProperty("头像")
    private String headPhoto;

    @ApiModelProperty("微信号")
    private String wechatNum;

    @ApiModelProperty("电话")
    @Length(min = 0,max = 11,message = "电话号码最多11位")
    private String phone;

    @ApiModelProperty("创建人")
    private Long creator;

    @ApiModelProperty("修改人")
    private Long updator;
}
