package com.pcloud.book.book.biz.impl;

import com.pcloud.book.book.entity.BookUserBrowseRecord;
import com.pcloud.book.book.dao.BookUserBrowseRecordDao;
import com.pcloud.book.book.biz.BookUserBrowseRecordBiz;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 书籍用户关联表(BookUserBrowseRecord)表服务实现类
 *
 * @author wubo
 * @since 2021-12-03 10:40:19
 */
@Service("bookUserBrowseRecordBiz")
public class BookUserBrowseRecordBizImpl implements BookUserBrowseRecordBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(BookUserBrowseRecordBizImpl.class);

    @Autowired
    private BookUserBrowseRecordDao bookUserBrowseRecordDao;

    @Override
    @ParamLog("通过ID查询单条数据")
    public BookUserBrowseRecord getById(Long bookId) {
        return bookUserBrowseRecordDao.getById(bookId);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = bookUserBrowseRecordDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)) {
            return pageBeanNew;
        }
        // 加载其它数据

        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public Long insert(BookUserBrowseRecord bookUserBrowseRecord) {
        bookUserBrowseRecordDao.insert(bookUserBrowseRecord);
        return bookUserBrowseRecord.getBookId();
    }

    @Override
    @ParamLog("修改")
    public void update(BookUserBrowseRecord bookUserBrowseRecord) {
        if (bookUserBrowseRecord == null || !NumberUtil.isNumber(bookUserBrowseRecord.getBookId())) {
            throw BizException.PARAM_IS_NULL;
        }
        bookUserBrowseRecordDao.update(bookUserBrowseRecord);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long bookId) {
        bookUserBrowseRecordDao.deleteById(bookId);
    }

    @Override
    @ParamLog("软删除")
    public void softDeleteById(Long bookId) {
        bookUserBrowseRecordDao.softDeleteById(bookId);
    }

    @Override
    public List<Long> getUserIdsByBookId(List<Long> bookIds) {
        if (ListUtils.isEmpty(bookIds)) {
            return new ArrayList<>();
        }
        return bookUserBrowseRecordDao.getUserIdsByBookId(bookIds);
    }
}
