/**
 *
 */
package com.pcloud.book.book.facade;

import com.pcloud.book.book.dto.*;
import com.pcloud.book.book.entity.Book;
import com.pcloud.book.book.vo.ListNoAuthBookParam;
import com.pcloud.book.book.vo.ListNoAuthGroupBookParam;
import com.pcloud.book.book.vo.request.BookQualifyInfoVO;
import com.pcloud.book.book.vo.request.BookSearchParamVO;
import com.pcloud.book.book.vo.request.UpdateBookRobotProcessDto;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.*;
import org.codehaus.jackson.JsonParseException;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * @描述：书籍接口
 * @作者：songx
 * @创建时间：2016年12月23日,下午2:37:02 @版本：1.0
 */
@Api(description = "书籍接口外部服务")
public interface BookFacade {

    @ApiOperation(value = "新增书籍(平台)", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "create", method = RequestMethod.POST)
    ResponseDto<BookDto> create(@RequestHeader("token") String token, @RequestBody Book book)
            throws BizException, PermissionException;

    @ApiOperation(value = "修改书籍信息(平台)", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "update", method = RequestMethod.POST)
    ResponseDto<?> update(@RequestHeader("token") String token, @RequestBody Book book)
            throws BizException, PermissionException;

    @ApiOperation(value = "修改书籍封面图", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "updateCoverImg", method = RequestMethod.POST)
    ResponseDto<?> updateCoverImg(@RequestHeader("token") String token, @RequestBody Book book)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "修改书籍信息(编辑)", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "updateByAdviser", method = RequestMethod.POST)
    ResponseDto<?> updateByAdviser(@RequestHeader("token") String token, @RequestBody Book book)
            throws BizException, PermissionException;

    @ApiOperation(value = "删除书籍信息(平台)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "delete", method = RequestMethod.GET)
    ResponseDto<?> delete(@RequestHeader("token") String token,
                          @RequestParam(value = "bookId") Long bookId)
            throws BizException, PermissionException;

    @ApiOperation(value = "批量删除书籍信息(平台)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookIds", value = "图书标识", dataType = "string", paramType = "query")})
    @RequestMapping(value = "deletes", method = RequestMethod.GET)
    ResponseDto<?> deletes(@RequestHeader("token") String token,
                           @RequestParam(value = "bookIds") String bookIds)
            throws BizException, PermissionException;

    @ApiOperation(value = "获取书籍基础信息(包含统计信息)（编辑端）", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getById", method = RequestMethod.GET)
    ResponseDto<BookDto> getById(@RequestHeader("token") String token,
                                 @RequestParam(value = "bookId") Long bookId,
                                 @RequestParam(value = "channelId") Long channelId)
            throws BizException, PermissionException;

    @ApiOperation(value = "获取书籍基础信息", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getBaseById", method = RequestMethod.GET)
    ResponseDto<BookDto> getBaseById(@RequestParam(value = "bookId") Long bookId)
            throws BizException;

    @ApiOperation(value = "判断书籍ISBN码是否存在(平台)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "typeCode", value = "书类型编码", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "isbn", value = "书籍号", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "serialNumber", value = "刊物序号", dataType = "string", paramType = "query")})
    @RequestMapping(value = "isbnExists", method = RequestMethod.GET)
    ResponseDto<Boolean> isbnExists(@RequestHeader("token") String token,
                                    @RequestParam(value = "typeCode", required = false) String typeCode,
                                    @RequestParam(value = "isbn") String isbn,
                                    @RequestParam(value = "serialNumber", required = false) String serialNumber)
            throws BizException, PermissionException;

    @ApiOperation(value = "判断书籍ISBN码是否存在(平台)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "publish", value = "出版社", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "fundName", value = "基金支持", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "bookName", value = "书籍名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "isbn", value = "书籍号", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "serialNumber", value = "刊物序号", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "isCurrentMonth", value = "当月基金支持书刊", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query")})
    @RequestMapping(value = "listPage", method = RequestMethod.GET)
    ResponseDto<?> getListPage(@RequestHeader("token") String token,
                               @RequestParam(value = "publish", required = false) String publish,
                               @RequestParam(value = "fundName", required = false) String fundName,
                               @RequestParam(value = "bookName", required = false) String bookName,
                               @RequestParam(value = "isbn", required = false) String isbn,
                               @RequestParam(value = "serialNumber", required = false) String serialNumber,
                               @RequestParam(value = "isCurrentMonth", required = false) Integer isCurrentMonth,
                               @RequestParam(value = "currentPage") Integer currentPage,
                               @RequestParam(value = "numPerPage") Integer numPerPage)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "判断书籍ISBN码是否存在(平台)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookName", value = "书籍名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "isbn", value = "isbn", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "typeCode", value = "书刊类型", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "isMainEditor", value = "只看我是主编辑", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "isFundSupport", value = "只看基金支持", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "bookId", value = "书籍标识", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "templetId", value = "图书类型标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "bookStatus", value = "图书版权保护状态", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "hasQrcode", value = "只看有二维码", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "isPrint", value = "是否已下印", dataType = "Boolean", paramType = "query"),
            @ApiImplicitParam(name = "isApproval", value = "是否已立项", dataType = "Boolean", paramType = "query"),
            @ApiImplicitParam(name = "isRelate", value = "是否已关联ERP", dataType = "Boolean", paramType = "query"),
            @ApiImplicitParam(name = "minimumSupport", value = "是否保底支持", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "proLabelId", value = "专业", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "depLabelId", value = "深度", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "purLabelId", value = "目的", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "areaLabelId", value = "地域", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "graLabelId", value = "年级", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "subLabelId", value = "科目", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "verLabelId", value = "版本", dataType = "int", paramType = "query")
    })
    @RequestMapping(value = "listPage4Adviser", method = RequestMethod.GET)
    ResponseDto<PageBean> getListPage4Adviser(@RequestHeader("token") String token,
                                              @RequestParam(value = "name", required = false) String name,
                                              @RequestParam(value = "bookName", required = false) String bookName,
                                              @RequestParam(value = "isbn", required = false) String isbn,
                                              @RequestParam(value = "channelId", required = false) Long channelId,
                                              @RequestParam(value = "typeCode", required = false) String typeCode,
                                              @RequestParam(value = "currentPage") Integer currentPage,
                                              @RequestParam(value = "numPerPage") Integer numPerPage,
                                              @RequestParam(value = "isMainEditor", required = false) Integer isMainEditor,
                                              @RequestParam(value = "isFundSupport", required = false) Integer isFundSupport,
                                              @RequestParam(value = "bookId", required = false) Integer bookId,
                                              @RequestParam(value = "templetId", required = false) Long templetId,
                                              @RequestParam(value = "bookStatus", required = false) Integer bookStatus,
                                              @RequestParam(value = "secondTempletId", required = false) Long secondTempletId,
                                              @RequestParam(value = "thirdTempletId", required = false) Long thirdTempletId,
                                              @RequestParam(value = "hasQrcode",required = false) Integer hasQrcode,
                                              @RequestParam(value = "isPrint", required = false) Boolean isPrint,
                                              @RequestParam(value = "isApproval", required = false) Boolean isApproval,
                                              @RequestParam(value = "isRelate", required = false) Boolean isRelate,
                                              @RequestParam(value = "minimumSupport", required = false) Integer minimumSupport,
                                              @RequestParam(value = "proLabelId", required = false) Integer proLabelId,
                                              @RequestParam(value = "depLabelId", required = false) Integer depLabelId,
                                              @RequestParam(value = "purLabelId", required = false) Integer purLabelId,
                                              @RequestParam(value = "areaLabelId", required = false) Integer areaLabelId,
                                              @RequestParam(value = "graLabelId", required = false) Integer graLabelId,
                                              @RequestParam(value = "subLabelId", required = false) Integer subLabelId,
                                              @RequestParam(value = "verLabelId", required = false) Integer verLabelId,
                                              @RequestParam(value = "appointBook", required = false) Integer appointBook,
                                              @RequestParam(value = "openRaysCode", required = false) Integer openRaysCode)
            throws BizException, PermissionException;

    @ApiOperation(value = "首页获取正在做的图书", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "num", value = "个数", dataType = "Integer", paramType = "query"),
            @ApiImplicitParam(name = "isPrint", value = "是否已下印", dataType = "Boolean", paramType = "query")
    })
    @GetMapping("getList4Adviser")
    ResponseDto<List<BookDto>> getList4Adviser(@RequestHeader("token") String token, @RequestParam(value = "num") Integer num,
            @RequestParam(value = "isPrint", required = false) Boolean isPrint,
                                               @RequestParam(value = "isApproval", required = false) Boolean isApproval) throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "获取书籍的详细信息（微信客户端）", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "书籍标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "adviserId", value = "编辑标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getDetailById", method = RequestMethod.GET)
    ResponseDto<BookDto> getDetailById(@CookieValue("userInfo") String userInfo,
                                       @RequestParam(value = "bookId", required = false) Long bookId,
                                       @RequestParam(value = "adviserId", required = false) Long adviserId)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "图书收益，获取书籍基础信息(包含统计信息)（编辑）", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "书籍标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getById4Profit", method = RequestMethod.GET)
    ResponseDto<BookDto> getById4Profit(@RequestHeader("token") String token,
                                        @RequestParam(value = "bookId") Long bookId,
                                        @RequestParam(value = "channelId") Long channelId)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "判断书籍ISBN码是否存在,存在则获取书籍信息（编辑）", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "isbnExistsOrGetInfo", method = RequestMethod.POST)
    ResponseDto<BookDto> isbnExistsOrGetInfo(@RequestHeader("token") String token, @RequestBody Book book)
            throws BizException, PermissionException, JsonParseException;


    @ApiOperation(value = "创建编辑书籍关联关系（编辑端）", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "setBookAdviserRelation", method = RequestMethod.POST)
    ResponseDto<?> setBookAdviserRelation(@RequestHeader("token") String token, @RequestBody Book book)
            throws BizException, PermissionException;

    /**
     * 获取书籍的基本信息(微信客户端)
     */
    @ApiOperation(value = "获取书籍的基本信息(微信客户端)", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookId", value = "书籍标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getBaseInfoById4Wechat", method = RequestMethod.GET)
    ResponseDto<BookDto> getBaseInfoById4Wechat(@CookieValue("userInfo") String userInfo,
                                                @RequestParam(value = "bookId") Long bookId)
            throws BizException, PermissionException;

    /**
     * 获取书籍列表(微信编辑端)
     */
    @ApiOperation(value = "获取书籍列表(微信编辑端)", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "bookName", value = "书籍名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getListPage4Wechat", method = RequestMethod.GET)
    ResponseDto<PageBean> getListPage4Wechat(@CookieValue("userInfo") String userInfo,
                                             @RequestParam(value = "currentPage") Integer currentPage,
                                             @RequestParam(value = "numPerPage") Integer numPerPage,
                                             @RequestParam(value = "bookName", required = false) String bookName,
                                             @RequestParam(value = "channelId", required = false) Long channelId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取书籍列表(XCX)
     */
    @ApiOperation(value = "获取书籍列表(XCX)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "bookName", value = "书籍名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getlistPage", method = RequestMethod.GET)
    ResponseDto<PageBean> listPage(@RequestHeader("token") String token,
                                   @RequestParam(value = "currentPage") Integer currentPage,
                                   @RequestParam(value = "numPerPage") Integer numPerPage,
                                   @RequestParam(value = "bookName", required = false) String bookName,
                                   @RequestParam(value = "channelId", required = false) Long channelId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 判断书籍ISBN码是否存在,存在则获取书籍信息(微信管理端-编辑)
     */
    @ApiOperation(value = "判断书籍ISBN码是否存在,存在则获取书籍信息(微信管理端-编辑)", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "isbnExistsOrGetInfo4Wechat", method = RequestMethod.POST)
    ResponseDto<BookDto> isbnExistsOrGetInfo4Wechat(@CookieValue("userInfo") String userInfo, @RequestBody Book book)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 创建编辑书籍关联关系(微信管理端-编辑)
     */
    @ApiOperation(value = "创建编辑书籍关联关系(微信管理端-编辑)", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "setBookAdviserRelation4Wechat", method = RequestMethod.POST)
    ResponseDto<?> setBookAdviserRelation4Wechat(@CookieValue("userInfo") String userInfo, @RequestBody Book book)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 微信端创建书籍(微信管理端-编辑)
     */
    @ApiOperation(value = "微信端创建书籍(微信管理端-编辑)", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "create4Wechat", method = RequestMethod.POST)
    ResponseDto<BookDto> create4Wechat(@CookieValue("userInfo") String userInfo, @RequestBody Book book)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 微信端修改书籍(微信管理端-编辑)
     */
    @ApiOperation(value = "微信端修改书籍(微信管理端-编辑)", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "update4Wechat", method = RequestMethod.POST)
    ResponseDto<BookDto> update4Wechat(@CookieValue("userInfo") String userInfo, @RequestBody Book book)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "根据ISBN获取期刊分页列表", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "typeCode", value = "书类型编码", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "isbn", value = "isbn", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query")})
    @RequestMapping(value = "getJournalPageByIsbn", method = RequestMethod.GET)
    ResponseDto<?> getJournalPageByIsbn(@CookieValue("userInfo") String userInfo,
                                        @RequestParam(value = "typeCode", required = false) String typeCode,
                                        @RequestParam(value = "isbn", required = false) String isbn,
                                        @RequestParam(value = "currentPage") Integer currentPage,
                                        @RequestParam(value = "numPerPage") Integer numPerPage)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取书籍列表(微信客户端)
     */
    @ApiOperation(value = "获取书籍列表(微信客户端)", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query")})
    @RequestMapping(value = "listPage4Wechat", method = RequestMethod.GET)
    ResponseDto<PageBean> listPage4Wechat(@CookieValue("userInfo") String userInfo,
                                          @RequestParam(value = "currentPage") Integer currentPage,
                                          @RequestParam(value = "numPerPage") Integer numPerPage)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取书籍列表(编辑)
     */
    @ApiOperation(value = "获取书籍列表(编辑)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "number", value = "书籍数目", dataType = "int", paramType = "query")})
    @RequestMapping(value = "listBook", method = RequestMethod.GET)
    ResponseDto<List<Object>> listBook(@RequestHeader("token") String token,
                                       @RequestParam(value = "number") Integer number)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取书籍列表(APP-编辑)
     */
    @ApiOperation(value = "获取书籍列表(APP-编辑)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "currentPage", value = "当前页数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "bookName", value = "书籍名称", dataType = "string", paramType = "query")})
    @RequestMapping(value = "listBook4App", method = RequestMethod.GET)
    ResponseDto<PageBean> listBook4App(@RequestHeader("token") String token,
                                       @RequestParam(value = "currentPage") Integer currentPage,
                                       @RequestParam(value = "numPerPage") Integer numPerPage,
                                       @RequestParam(value = "bookName", required = false) String bookName)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 书刊列表-出版端
     */
    @ApiOperation(value = "书刊列表-出版端", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookName", value = "书刊名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "typeCode", value = "书刊类型", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "mainEditorName", value = "主编辑名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "isFundSupport", value = "基金支持", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "isbn", value = "isbn", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "templetId", value = "图书类型标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "secondTempletId", value = "图书类型二级标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "isPrint", value = "是否已下印", dataType = "Boolean", paramType = "query"),
            @ApiImplicitParam(name = "minimumSupport", value = "是否保底支持", dataType = "int", paramType = "query")
    })
    @RequestMapping(value = "listPage4Agent", method = RequestMethod.GET)
    ResponseDto<PageBean> listPage4Agent(@RequestHeader("token") String token,
                                         @RequestParam(value = "bookName", required = false) String bookName,
                                         @RequestParam(value = "channelId", required = false) Long channelId,
                                         @RequestParam(value = "typeCode", required = false) String typeCode,
                                         @RequestParam(value = "currentPage", required = false) Integer currentPage,
                                         @RequestParam(value = "numPerPage", required = false) Integer numPerPage,
                                         @RequestParam(value = "mainEditorName", required = false) String mainEditorName,
                                         @RequestParam(value = "isFundSupport", required = false) Integer isFundSupport,
                                         @RequestParam(value = "isbn", required = false) String isbn,
                                         @RequestParam(value = "templetId", required = false) Long templetId,
                                         @RequestParam(value = "secondTempletId", required = false) Long secondTempletId,
                                         @RequestParam(value = "thirdTempletId", required = false) Long thirdTempletId,
                                        @RequestParam(value = "isPrint", required = false) Boolean isPrint,
                                         @RequestParam(value = "minimumSupport", required = false) Integer minimumSupport,
                                         @RequestParam(value = "startTime", required = false) String startTime,
                                         @RequestParam(value = "endTime", required = false) String endTime)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取应用关联的图书
     */
    @ApiOperation(value = "获取应用关联的图书", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "appId", value = "应用标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "listBookByAppId", method = RequestMethod.GET)
    ResponseDto<List<BookDto>> listBookByAppId(@RequestHeader("token") String token,
                                               @RequestParam(value = "appId", required = false) Long appId,
                                               @RequestParam(value = "channelId", required = false) Long channelId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取书籍基础信息(包含统计信息)（出版端）
     */
    @ApiOperation(value = "获取书籍基础信息(包含统计信息)（编辑端）", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "adviserId", value = "编辑标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getById4Agent", method = RequestMethod.GET)
    ResponseDto<BookDto> getById4Agent(@RequestHeader("token") String token,
                                       @RequestParam(value = "bookId") Long bookId,
                                       @RequestParam(value = "channelId", required = false) Long channelId,
                                       @RequestParam(value = "adviserId", required = false) Long adviserId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取书籍基础信息（平台端）
     */
    @ApiOperation(value = "获取书籍基础信息（平台端）", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "adviserId", value = "编辑标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getById4Platform", method = RequestMethod.GET)
    ResponseDto<BookDto> getById4Platform(@RequestHeader("token") String token,
            @RequestParam(value = "bookId") Long bookId,
            @RequestParam(value = "channelId", required = false) Long channelId,
            @RequestParam(value = "adviserId", required = false) Long adviserId)
            throws BizException;

    /**
     * 书刊回收站列表（30天内删除的书刊列表）
     */
    @ApiOperation(value = "书刊回收站列表", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "currentPage", value = "当前页数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query")})
    @RequestMapping(value = "listPageDelete4Adviser", method = RequestMethod.GET)
    ResponseDto<PageBean> listPageDelete4Adviser(@RequestHeader("token") String token,
                                                 @RequestParam(value = "currentPage") Integer currentPage,
                                                 @RequestParam(value = "numPerPage") Integer numPerPage)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取图书关联超级作者商品个数
     */
    @ApiOperation(value = "获取图书统计个数", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getCount4BookAssoc", method = RequestMethod.GET)
    ResponseDto<BookAssocCount> getCount4BookAssoc(@RequestHeader("token") String token,
                                                   @RequestParam(value = "bookId") Long bookId,
                                                   @RequestParam(value = "channelId", required = false) Long channelId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 导出所有书刊成excel表 - 出版端
     */
    @ApiOperation(value = "导出出版下所有书刊excel表（出版端）", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header")})
    @RequestMapping(value = "exportBookToExcel", method = RequestMethod.GET)
    ResponseDto<?> exportBookToExcel(@RequestHeader("token") String token)
            throws PermissionException, JsonParseException, BizException;

    /**
     * 图书列表（平台端）
     */
    @ApiOperation(value = "图书列表（平台端）", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "typeCode", value = "书刊类型", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "templetId", value = "书刊分类标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "startDate", value = "开始日期", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "endDate", value = "结束日期", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "bookName", value = "书刊名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "secondTempletId", value = "书刊分类二级列表标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "isPrint", value = "是否已下印", dataType = "Boolean", paramType = "query"),
            @ApiImplicitParam(name = "isApproval", value = "是否立项", dataType = "int", paramType = "query")
    })
    @RequestMapping(value = "listBookClassify", method = RequestMethod.GET)
    ResponseDto<PageBean> listBookClassify(@RequestHeader("token") String token,
                                           @RequestParam(value = "typeCode", required = false) String typeCode,
                                           @RequestParam(value = "templetId", required = false) Long templetId,
                                           @RequestParam(value = "startDate", required = false) String startDate,
                                           @RequestParam(value = "endDate", required = false) String endDate,
                                           @RequestParam(value = "bookName", required = false) String bookName,
                                           @RequestParam(value = "publish", required = false) String publish,
                                           @RequestParam(value = "currentPage") Integer currentPage,
                                           @RequestParam(value = "numPerPage") Integer numPerPage,
                                           @RequestParam(value = "secondTempletId", required = false) Long secondTempletId,
                                           @RequestParam(value = "thirdTempletId", required = false) Long thirdTempletId,
                                           @RequestParam(value = "isPrint", required = false) Boolean isPrint,
                                           @RequestParam(value = "isApproval", required = false) Integer isApproval)
            throws BizException, PermissionException, JsonParseException;


    /**
     * 导出图书列表（平台端）
     */
    @ApiOperation("导出图书列表（平台端）")
    @GetMapping("exportBookClassify")
    ResponseDto<?> exportBookClassify(
            @RequestHeader("token") String token,
            @RequestParam(value = "typeCode", required = false) String typeCode,
            @RequestParam(value = "templetId", required = false) Long templetId,
            @RequestParam(value = "startDate", required = false) String startDate,
            @RequestParam(value = "endDate", required = false) String endDate,
            @RequestParam(value = "bookName", required = false) String bookName,
            @RequestParam(value = "publish", required = false) String publish,
            @RequestParam(value = "secondTempletId", required = false) Long secondTempletId,
            @RequestParam(value = "thirdTempletId", required = false) Long thirdTempletId
    ) throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "导出平台下所有书刊excel表（平台端）", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header")})
    @RequestMapping(value = "exportBookToExcel4Platform", method = RequestMethod.GET)
    ResponseDto<?> exportBookToExcel4Platform(@RequestHeader("token") String token)
            throws PermissionException, JsonParseException, BizException;

    /**
     * 通过isbn获取图书信息(编辑端new)
     */
    @ApiOperation(value = "通过isbn获取图书信息(编辑端new)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "isbn", value = "书籍号", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "typeCode", value = "图书类型", dataType = "string", paramType = "query")})
    @RequestMapping(value = "getByIsbnAndTypeCode", method = RequestMethod.GET)
    ResponseDto<BookDto> getByIsbnAndTypeCode(@RequestHeader("token") String token,
                                              @RequestParam(value = "isbn") String isbn,
                                              @RequestParam(value = "typeCode") String typeCode)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 新增书籍(编辑)
     */
    @ApiOperation(value = "新增书籍(编辑)", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "create4Adviser", method = RequestMethod.POST)
    ResponseDto<BookDto> create4Adviser(@RequestHeader("token") String token, @RequestBody Book book, HttpServletRequest request)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 根据ISBN码获取书籍 to exapi
     */
    @ApiOperation(value = "根据ISBN码和serialNumber获取书籍", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "isbn", value = "isbn", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "serialNumber", value = "刊物序号", dataType = "string", paramType = "query")})
    @RequestMapping(value = "/getByIsbnAndSerialNumber", method = RequestMethod.GET)
    ResponseDto<BookDto> getByIsbnAndSerialNumber(@RequestParam(value = "isbn", required = true) String isbn,
                                                  @RequestParam(value = "serialNumber", required = false) String serialNumber) throws BizException;


    /**
     * 修改图书类型与图书基本信息
     */
    @ApiOperation(value = "修改图书类型与图书基本信息（编辑）", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "updateBookAndBookType", method = RequestMethod.POST)
    public ResponseDto<?> updateBookAndBookType(@RequestHeader("token") String token, @RequestBody Book book)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "校验ISBN", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "isbn", value = "ISBN码", dataType = "String", paramType = "query")})
    @RequestMapping(value = "checkISBN4App", method = RequestMethod.GET)
    ResponseDto<Boolean> checkISBN4App(@RequestHeader("token") String token, @RequestParam String isbn) throws PermissionException;


    @ApiOperation(value = "根据渠道ID分页获取图书列表", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "name", value = "图书名称、isbn", dataType = "string", paramType = "query")
    })
    @GetMapping("getBookListByChannelId4Adviser")
    ResponseDto<PageBean> getBookListByChannelId4Adviser(
            @RequestHeader("token") String token, @RequestParam(value = "currentPage") Integer currentPage,
            @RequestParam(value = "numPerPage") Integer numPerPage, @RequestParam(value = "channelId", required = false) Long channelId,
            @RequestParam(value = "name", required = false) String name) throws PermissionException, JsonParseException, BizException;

    @RequestMapping(value = "listNoAuthBook", method = RequestMethod.POST)
    @ApiOperation(value = "获取未设置正版授权的图书", httpMethod = "POST")
    ResponseDto<PageBeanNew> listNoAuthBook(@RequestHeader("token") String token,
                                                   @RequestBody ListNoAuthBookParam listNoAuthBookParam) throws PermissionException;

    @RequestMapping(value = "listNoAuthGroupBook", method = RequestMethod.POST)
    @ApiOperation(value = "获取未设置正版授权的社群书", httpMethod = "POST")
    ResponseDto<PageBeanNew> listNoAuthGroupBook(@RequestHeader("token") String token,
                                            @RequestBody ListNoAuthGroupBookParam listNoAuthGroupBookParam) throws PermissionException;

    @ApiOperation("平台端 获取1v1社群书书刊列表")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "currentPage", value = "当前页数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "name", value = "图书名称、isbn", dataType = "string", paramType = "query")
    })
    @RequestMapping(value = "getListPage4SelfBookGroup", method = RequestMethod.GET)
    public ResponseDto<PageBeanNew<AdviserBookInfoDTO>> getListPage4SelfBookGroup(
            @RequestHeader("token") String token,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "graLabelId", required = false) Long graLabelId,
            @RequestParam(value = "subLabelId", required = false) Long subLabelId,
            @RequestParam(value = "verLabelId", required = false) Long verLabelId,
            @RequestParam(value = "areaLabelId", required = false) Long areaLabelId,
            @RequestParam(value = "currentPage", required = false) Integer currentPage,
            @RequestParam(value = "numPerPage", required = false) Integer numPerPage)
            throws BizException, PermissionException;

    @ApiOperation("获取书籍标签")
    @GetMapping("getBookLabels")
    ResponseDto<?> getBookLabels(
            @RequestHeader("token") String token
    ) throws BizException, PermissionException;

    /**
     * 书刊收益列表-出版端
     */
    @ApiOperation(value = "书刊收益列表-出版端", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "keyWord", value = "关键词", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "typeCode", value = "书刊类型", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "isFundSupport", value = "基金支持", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "templetId", value = "图书类型标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "secondTempletId", value = "图书类型二级标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "minimumSupport", value = "保底支持", dataType = "int", paramType = "query")})
    @RequestMapping(value = "listPageIncomeDetail", method = RequestMethod.GET)
    ResponseDto<PageBeanNew> listPageIncomeDetail(@RequestHeader("token") String token,
                                         @RequestParam(value = "keyWord", required = false) String keyWord,
                                         @RequestParam(value = "channelId", required = false) Long channelId,
                                         @RequestParam(value = "typeCode", required = false) String typeCode,
                                         @RequestParam(value = "currentPage", required = false) Integer currentPage,
                                         @RequestParam(value = "numPerPage", required = false) Integer numPerPage,
                                         @RequestParam(value = "isFundSupport", required = false) Integer isFundSupport,
                                         @RequestParam(value = "templetId", required = false) Long templetId,
                                         @RequestParam(value = "secondTempletId", required = false) Long secondTempletId,
                                         @RequestParam(value = "thirdTempletId", required = false) Long thirdTempletId,
                                                  @RequestParam(value = "startTime", required = false) String startTime,
                                                  @RequestParam(value = "endTime", required = false) String endTime,
                                                  @RequestParam(value = "minimumSupport", required = false) Integer minimumSupport)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation("导出书刊收益")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "keyWord", value = "关键词", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "typeCode", value = "书刊类型", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "isFundSupport", value = "基金支持", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "templetId", value = "图书类型标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "secondTempletId", value = "图书类型二级标识", dataType = "long", paramType = "query")})
    @GetMapping("exportBookIncomeDetail")
    ResponseDto<?> exportBookIncomeDetail(
            @RequestHeader("token") String token,
            @RequestParam(value = "keyWord", required = false) String keyWord,
            @RequestParam(value = "channelId", required = false) Long channelId,
            @RequestParam(value = "typeCode", required = false) String typeCode,
            @RequestParam(value = "isFundSupport", required = false) Integer isFundSupport,
            @RequestParam(value = "templetId", required = false) Long templetId,
            @RequestParam(value = "secondTempletId", required = false) Long secondTempletId,
            @RequestParam(value = "startTime", required = false) String startTime,
            @RequestParam(value = "endTime", required = false) String endTime,
            @RequestParam(value = "thirdTempletId", required = false) Long thirdTempletId)
            throws PermissionException, BizException;

    @ApiOperation("编辑端 获取1v1社群书书刊列表")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "name",value = "书刊名称",dataType = "String",paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query")
    })
    @RequestMapping(value = "getListPage4SelfBookGroupByAdvise", method = RequestMethod.GET)
    public ResponseDto<PageBeanNew<AdviserBookInfoDTO>> getListPage4SelfBookGroupByAdvise(
            @RequestHeader("token") String token,
            @RequestParam(value = "name",required = false) String name,
            @RequestParam(value = "currentPage", required = false) Integer currentPage,
            @RequestParam(value = "numPerPage", required = false) Integer numPerPage)
            throws BizException, PermissionException;

    @ApiOperation("平台端获取书刊列表")
    @GetMapping("getAdviserBooks4Pcloud")
    ResponseDto<?> getAdviserBooks4Pcloud(
            @RequestHeader("token") String token,
            @RequestParam(value = "keyword", required = false) String keyword,
            @RequestParam(value = "agentId", required = false) Long agentId,
            @RequestParam(value = "templetId", required = false) Long templetId,
            @RequestParam(value = "secondTempletId", required = false) Long secondTempletId,
            @RequestParam(value = "thirdTempletId", required = false) Long thirdTempletId,
            @RequestParam(value = "typeCode", required = false) String typeCode,
            @RequestParam(value = "currentPage") Integer currentPage,
            @RequestParam(value = "numPerPage") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("获取书刊列表H5")
    @GetMapping("getAdviserBooks4H5")
    ResponseDto<?> getAdviserBooks4H5(
            @RequestHeader(value = "Gray-Status") String grayStatus,
            @RequestParam(value = "keyword", required = false) String keyword,
            @RequestParam(value = "templetId", required = false) Long templetId,
            @RequestParam(value = "secondTempletId", required = false) Long secondTempletId,
            @RequestParam(value = "thirdTempletId", required = false) Long thirdTempletId,
            @RequestParam(value = "currentPage") Integer currentPage,
            @RequestParam(value = "numPerPage") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation(value = "根据渠道ID分页获取图书列表及配置资源列表", httpMethod = "GET")
    @GetMapping("getBookAndServeList4Channel")
    ResponseDto<?> getBookAndServeList4Channel(
            @RequestHeader("token") String token,
            @RequestParam(value = "currentPage") @ApiParam("当前页数") Integer currentPage,
            @RequestParam(value = "numPerPage") @ApiParam("每页条数") Integer numPerPage,
            @RequestParam(value = "name", required = false) @ApiParam("图书名称、isbn") String name,
            @RequestParam(value = "isFundSupport", required = false) @ApiParam("只看基金支持") Integer isFundSupport,
            @RequestParam(value = "startDate", required = false) @ApiParam("开始日期") String startDate,
            @RequestParam(value = "endDate", required = false) @ApiParam("结束日期") String endDate
    ) throws PermissionException, JsonParseException, BizException;

    @ApiOperation("获取书刊")
    @GetMapping("getAdviserBook")
    ResponseDto<?> getAdviserBook(
            @RequestParam(value = "bookId", required = false) Long bookId,
            @RequestParam(value = "adviserId", required = false) Long adviserId,
            @RequestParam(value = "channelId", required = false) Long channelId,
            @RequestParam(value = "sceneId", required = false) Long sceneId
    ) throws BizException, PermissionException;

    @ApiOperation(value = "批量更新质检书刊", httpMethod = "POST")
    @RequestMapping(value = "updateBookQualifyInfo", method = RequestMethod.POST)
    public ResponseDto<?> updateBookQualifyInfo(@RequestHeader("token") String token, @RequestBody BookQualifyInfoVO bookQualifyInfo ) throws PermissionException;

    @ApiOperation(value = "查询添加书刊列表", httpMethod = "GET")
    @GetMapping("getAddBookQualifyList")
    ResponseDto<?> getAddBookQualifyList(
            @RequestHeader("token") String token,
            @RequestParam(value = "currentPage") @ApiParam("当前页数") Integer currentPage,
            @RequestParam(value = "numPerPage") @ApiParam("每页条数") Integer numPerPage,
            @RequestParam(value = "name", required = false) @ApiParam("图书名称、isbn") String name,
            @RequestParam(value = "isShowQualifyInfo", required = false) Integer isShowQualifyInfo
    ) throws PermissionException, JsonParseException, BizException;

    @ApiOperation(value = "码后根据bookGroupId查询本书信息", httpMethod = "GET")
    @GetMapping("getBookInfoByBookGroupId")
    public ResponseDto<?> getBookInfoByBookGroupId(
            @RequestParam(value = "bookGroupId") Long bookGroupId
    ) throws PermissionException, JsonParseException, BizException;

    @ApiOperation(value = "社群书更新书刊是否开启小睿流程", httpMethod = "POST")
    @RequestMapping(value = "updateIsOpenRobotProcess", method = RequestMethod.POST)
    public ResponseDto<?> updateIsOpenRobotProcess(@RequestHeader("token") String token, @RequestBody UpdateBookRobotProcessDto robotProcessDto ) throws PermissionException;

    @ApiOperation(value = "现代纸书更新书刊是否开启小睿流程", httpMethod = "POST")
    @RequestMapping(value = "updateIsOpenRobotProcess4Now", method = RequestMethod.POST)
    public ResponseDto<?> updateIsOpenRobotProcess4Now(@RequestHeader("token") String token, @RequestBody UpdateBookRobotProcessDto robotProcessDto ) throws PermissionException;

    @ApiOperation("小程序首页书刊搜索")
    @PostMapping("getAdviserBooks4Applet")
    public ResponseDto<?> getAdviserBooks4Applet(
            @RequestBody @Validated BookSearchParamVO bookSearchParamVO
    ) throws BizException, PermissionException;

    @ApiOperation(value = "批量获取书籍信息（书名 与书刊序号 封面图）", httpMethod = "POST")
    @RequestMapping(value = "/listBaseByIds", method = RequestMethod.POST)
    public ResponseDto<Map<Long, BookDto>> listBaseByIds(@RequestBody(required = false) List<Long> bookIds)
            throws BizException;

    @ApiOperation("批量获取书籍信息")
    @RequestMapping(value = "/listBookGroupByBookIds", method = RequestMethod.POST)
    ResponseDto<Map<String, BookDto>> listBookGroupByBookIds(@RequestBody MapResourceTotalCountDTO bookDetailDTO) throws BizException;

    @ApiOperation("获取书刊标签")
    @RequestMapping(value = "/getLabelMapByIds", method = RequestMethod.POST)
    public ResponseDto<Map<Long, String>> getLabelMapByIds(
            @RequestBody List<Long> labelIds
    ) throws BizException;

    @ApiOperation("erp关联书刊全局唯一id")
    @RequestMapping(value = "/relateUniqueNumber4Erp", method = RequestMethod.POST)
    public ResponseDto<?> relateUniqueNumber4Erp(
            @RequestBody List<BookUniqueNumberDTO> bookUniqueNumberVos
    ) throws BizException;

    @ApiOperation("erp关联自动创建书刊")
    @RequestMapping(value = "/relateBookAdviser4Erp", method = RequestMethod.POST)
    ResponseDto<?> relateBookAdviser4Erp(@RequestBody RelateAdviserVO relateAdviserVO) throws BizException;

    @ApiOperation("erp自动创建RAYS书刊")
    @RequestMapping(value = "/batchCreateBook4Erp", method = RequestMethod.POST)
    ResponseDto<?> batchCreateBook4Erp(@RequestBody List<CreateBookVO> createBookVOList) throws BizException;

    @ApiOperation("erp创建书刊插入数据到mq")
    @RequestMapping(value = "/addCreateInfoToMq", method = RequestMethod.POST)
    ResponseDto<?> addCreateInfoToMq(@RequestBody List<CreateBookVO> createBookVOList) throws BizException;
}
