package com.pcloud.book.book.facade;

import com.pcloud.book.book.biz.BookCoverBiz;
import com.pcloud.book.book.biz.BookSwitchBiz;
import com.pcloud.book.book.dto.BookCoverDTO;
import com.pcloud.book.book.entity.BookSwitch;
import com.pcloud.book.book.vo.request.BookSwitchParam;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

@RestController
@Api(description = "图书活动开关服务")
public class BookSwitchFacade {
    @Autowired
    private BookSwitchBiz bookSwitchBiz;

    @ApiOperation("保存开关")
    @RequestMapping(value = "/book/saveSwitch", method = RequestMethod.POST)
    public ResponseDto<?> saveSwitch(@RequestHeader("token") String token, @RequestBody BookSwitchParam param) {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        param.setPartyId(partyId);
        bookSwitchBiz.saveSwitch(param);
        return new ResponseDto<>();
    }
    @ApiOperation("批量保存开关")
    @RequestMapping(value = "/book/batchSaveSwitch", method = RequestMethod.POST)
    public ResponseDto<?> batchSaveSwitch(@RequestHeader("token") String token, @RequestBody BookSwitchParam param) {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        param.setPartyId(partyId);
        bookSwitchBiz.batchSaveSwitch(param);
        return new ResponseDto<>();
    }

}

