package com.pcloud.book.book.facade.impl;

import com.pcloud.book.book.biz.BookFreezeBiz;
import com.pcloud.book.book.dto.BookFreezeDto;
import com.pcloud.book.book.entity.BookFreeze;
import com.pcloud.book.book.entity.ThawEarning;
import com.pcloud.book.book.facade.BookFreezeFacade;
import com.pcloud.book.book.vo.BookFreezeFilterVO;
import com.pcloud.book.book.vo.BookFreezeInfoDto;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.ApiOperation;
import org.codehaus.jackson.JsonParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 图书冻结接口实现类
 * 
 * @author lili
 * @date 2018/1/18 18:13
 */
@RequestMapping("/bookFreeze")
@RestController("bookFreezeFacade")
public class BookFreezeFacadeImpl implements BookFreezeFacade {
	@Autowired
	private BookFreezeBiz bookFreezeBiz;

	/**
	 * 冻结收益
	 */
	@Override
	@RequestMapping(value = "create", method = RequestMethod.POST)
	public ResponseDto<?> create(@RequestHeader("token") String token, @RequestBody BookFreeze bookFreeze)
			throws BizException, PermissionException, JsonParseException {
		Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		bookFreeze.setCreatedUser(partyId);
		bookFreezeBiz.create(bookFreeze);
		return new ResponseDto<>();
	}

	/**
	 * 获取冻结信息
	 */
	@Override
	@RequestMapping(value = "getBaseById", method = RequestMethod.GET)
	public ResponseDto<BookFreezeDto> getBaseById(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId)
			throws BizException, PermissionException, JsonParseException {
		SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		BookFreezeDto bookFreezeDto = bookFreezeBiz.getBaseById(bookId);
		return new ResponseDto<>(bookFreezeDto);
	}

	/**
	 * 获取冻结信息（微信端）
	 */
	@Override
	@RequestMapping(value = "getBaseById4Wechat", method = RequestMethod.GET)
	public ResponseDto<BookFreezeDto> getBaseById4Wechat(@CookieValue("userInfo") String userInfo,
			@RequestParam(value = "bookId", required = false) Long bookId)
			throws BizException, PermissionException, JsonParseException {
		Cookie.getId(userInfo, Cookie._PARTY_ID);
		BookFreezeDto bookFreezeDto = bookFreezeBiz.getBaseById(bookId);
		return new ResponseDto<>(bookFreezeDto);
	}

	/**
	 * 解冻收益
	 */
	@Override
	@RequestMapping(value = "thaw", method = RequestMethod.POST)
	public ResponseDto<?> thaw(@RequestHeader("token") String token, @RequestBody ThawEarning thawEarning)
			throws BizException, PermissionException, JsonParseException {
		Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		bookFreezeBiz.thaw(thawEarning, partyId);
		return new ResponseDto<>();
	}

	@RequestMapping(value = "isFreeze", method = RequestMethod.GET)
	public ResponseDto<Boolean> isFreeze(@RequestParam(value = "bookId") Long bookId)
			throws BizException {
		final Boolean freeze = bookFreezeBiz.isFreeze(bookId);
		return new ResponseDto<>(freeze);
	}

	@ApiOperation("设置书刊冻结")
	@GetMapping("setBookFreeze")
	public ResponseDto<?> setBookFreeze(@RequestParam(value = "bookId") Long bookId)
			throws BizException, PermissionException, JsonParseException {
		return new ResponseDto<>(bookFreezeBiz.setBookFreeze(bookId));
	}

	@ApiOperation("filterBook4Erp")
	@PostMapping("filterBook4Erp")
	public ResponseDto<List<Long>> filterBook4Erp(@RequestBody BookFreezeFilterVO bookFreezeFilterVO){
		return new ResponseDto<>(bookFreezeBiz.filterBook4Erp(bookFreezeFilterVO));
	}

	@PostMapping("listBookFreezeInfo")
	public ResponseDto<List<BookFreezeInfoDto>> listBookFreezeInfo(@RequestBody List<Long> bookIds){
		return new ResponseDto<>(bookFreezeBiz.listBookFreezeInfo(bookIds));
	}
}
