package com.pcloud.book.es.biz;

import com.pcloud.book.book.vo.request.BookSearchParamVO;
import com.pcloud.book.es.entity.ESBookAndAdviser;
import com.pcloud.universe.commons.paging.Pagination;

import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2020/4/13 12:21
 **/
public interface ESBookAndAdviserBiz {
    void addAllBookAndAdviserToES();

    void updateBookAndAdviserToES(List<Long> bookIds);

    Pagination<ESBookAndAdviser> getAdviserBooks4ES(String grayStatus, String keyword, Long templetId, Long secondTempletId, Long thirdTempletId, Integer currentPage, Integer numPerPage);

    Pagination<ESBookAndAdviser> getESAdviserBooks4Applet(String grayStatus, String keyword, List<Long> templetIds, List<Long> graLabelIds, List<Long> subLabelIds, Integer currentPage, Integer numPerPage, List<Long> scecondTempletIds, Integer isAdviserBook, List<Long> adviserIds, Long agentId);

    Pagination<ESBookAndAdviser> getESAdviserBooks4AppletV2(String grayStatus, String keyword, List<Long> templetIds, List<Long> graLabelIds, List<Long> subLabelIds, Integer currentPage, Integer numPerPage, List<Long> scecondTempletIds, List<Long> adviserIds, Long agentId);

    /**
     * 答案，搜索全平台书刊
     * @author：zhuyajie
     * @date：2020/11/4 13:52
     *  * @param null
     */
    Pagination<ESBookAndAdviser> getESAdviserBooks4Answer(BookSearchParamVO bookSearchParamVO);
    /**
     * 系列书搜索
     * @author：zhuyajie
     * @date：2020/11/23 17:26
     *  * @param null
     */
    Pagination<ESBookAndAdviser> getAdviserBooks4SeriesBook(String keyword, Integer currentPage, Integer numPerPage, List<Long> adviserIds, Long agentId, Long subLabelId, Long graLabelId, String serialNumber, Long verLabelId, Long volLabelId);

    Map<String, Object> getNotFoundBookId(String lastBookId)throws Exception;

    void stopNotFoundBookId();

    /**
     * 查所有书刊，选中的在前
     * @author：zhuyajie
     * @date：2021/4/16 14:34
     *  * @param null
     */
    Pagination<ESBookAndAdviser> getESBooksOrderByChose(String keyword, List<Long> choseBookIdList, Integer currentPage, Integer numPerPage);

}
