package com.pcloud.book.group.biz;

import com.pcloud.book.book.dto.RaysSceneCatalogDto;
import com.pcloud.book.group.dto.AddBookGroupServeDTO;
import com.pcloud.book.group.dto.BookGroupServeCountDTO;
import com.pcloud.book.group.dto.BookGroupServeDTO;
import com.pcloud.book.group.dto.BookServeDTO;
import com.pcloud.book.group.dto.MessagServeDTO;
import com.pcloud.book.group.dto.NavigationParamDTO;
import com.pcloud.book.group.dto.ResourcePageCourseDTO;
import com.pcloud.book.group.dto.ResourcePageDTO;
import com.pcloud.book.group.dto.ResourcePageShareDto;
import com.pcloud.book.group.entity.BookGroupServe;
import com.pcloud.book.group.entity.ResourcePage;
import com.pcloud.book.group.entity.ResourcePageCollect;
import com.pcloud.book.group.entity.ResourcePagePic;
import com.pcloud.book.group.entity.ResourcePageTool;
import com.pcloud.book.group.entity.ResourceRecomManage;
import com.pcloud.book.group.vo.RecommendServeVO;
import com.pcloud.book.group.vo.ResourceColumnAndServeVO;
import com.pcloud.book.group.vo.ResourcePageItemResourceVO;
import com.pcloud.book.group.vo.ResourcePageItemVO;
import com.pcloud.book.group.vo.ResourcePageOneServe;
import com.pcloud.book.group.vo.ResourcePageShareParam;
import com.pcloud.book.group.vo.ResourcePageVO;
import com.pcloud.book.group.vo.UpdateResourceColumnVO;
import com.pcloud.book.group.vo.UpdateResourcePageVO;
import com.pcloud.book.group.vo.WxworkPageCreateVO;
import com.pcloud.book.group.vo.WxworkPageVO;
import com.pcloud.channelcenter.qrcode.dto.BookSceneIdListDTO;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.group.biz.ResourcePageBiz
 * @Author zhuyajie
 * @Description 自有码H5页面
 * @Date 2021/3/26 15:57
 * @Version 1.0
 **/
public interface ResourcePageBiz {


    /**
     * 更新资源页设置
     * @author：zhuyajie
     * @date：2021/3/26 17:05
     *  * @param null
     */
    Long updateResourcePage(UpdateResourcePageVO updateResourcePageVO);
    /**
     * @Description  创建默认资源页
     * @Author zhuyajie
     * @Date 13:38 2021/12/1
     **/
    ResourcePage createDefaultResourcePage(Long bookGroupId, Long adviserId, Long sceneId, Integer openRays, Integer landingPageType);
    /**
     * 更新资源栏目设置
     * @author：zhuyajie
     * @date：2021/3/26 17:27
     *  * @param null
     */
    void updateResourceColumn(UpdateResourceColumnVO updateResourceColumnVO) throws BizException;

    /**
     * 根据rays码id查资源页基本配置
     * @author：zhuyajie
     * @date：2021/3/26 17:49
     *  * @param null
     */
    ResourcePageVO getResourcePageByBookGroupIdOrSceneId(Long bookGroupId, Long adviserId, Long sceneId);

    /**
     * 根据rays码id查资源页栏目及资源
     * @author：zhuyajie
     * @date：2021/3/29 11:49
     *  * @param null
     */
    List<ResourceColumnAndServeVO> getColumnAndServeListByPageId(Long resourcePageId, Long wechatUserId, Long bookId, Long adviserId, Long channelId, Integer enableAdverting, Long navigationId);
    /**
     * 根据书刊查资源页基本配置
     * @author：zhuyajie
     * @date：2021/3/30 10:25
     *  * @param null
     */
    ResourcePageVO getResourcePageByBookId(Long bookId, Long channelId, Long adviserId, Long wechatUserId);

    /**
     * 栏目分页查询
     * @author：zhuyajie
     * @date：2021/3/31 19:06
     *  * @param null
     */
    PageBeanNew<ResourcePageItemVO> listPageResourcePageItem(Integer currentPage, Integer numPerPage, Long resourcePageColumnId, Long wechatUserId,Long officialAccountsId);

    /**
     * 根据社群码id查询
     * @author：zhuyajie
     * @date：2021/4/1 15:25
     *  * @param null
     */
    ResourcePage getPageByBookGroupId(Long bookGroupId);
    /**
     * 获取栏目及资源类型
     * @author：zhuyajie
     * @date：2021/4/1 16:17
     *  * @param null
     */
    List<Map<String,Object>> getColumnAndServeTypeList();

    /**
     * 栏目上移下移
     * @author：zhuyajie
     * @date：2021/4/2 14:53
     *  * @param null
     */
    void updateColumnSeq(Long resourcePageColumnId, String moveType);
    /**
     * 删除栏目
     * @author：zhuyajie
     * @date：2021/4/2 15:14
     *  * @param null
     */
    void deleteColumnById(Long resourcePageColumnId);
    /**
     * 更新资源页和栏目
     * @author：zhuyajie
     * @date：2021/4/6 17:09
     *  * @param null
     */
    Long updateResourcePageAndColumn(UpdateResourcePageVO updateResourcePageVO);

    public String getQrcodeOneServe(Long bookGroupId,Long sceneId,Boolean ignoreRays);

    void updateQrcodeOneServe(Long bookGroupId,Long sceneId,Boolean ignoreRays);

    /**
     * 客户端根据rays码id查资源页基本配置
     * @author：zhuyajie
     * @date：2021/4/9 17:39
     *  * @param null
     */
    ResourcePageVO getResourcePageByBookGroupIdOrSceneId4Wechat(Long bookGroupId, Long wechatUserId, Long sceneId);

    /**
     * 资源数量
     * @author：zhuyajie
     * @date：2021/4/16 13:39
     *  * @param null
     */
    Integer getResourceCounts(Long bookId, Long adviserId, Long channelId);

    /**
     * 查应用作品资源
     * @author：zhuyajie
     * @date：2021/4/17 13:12
     *  * @param null
     */
    List<BookGroupServe> getServeListByBookGroupId(Long bookGroupId);
    /**
     * 批量更新资源页应用作品链接
     * @author：zhuyajie
     * @date：2021/5/27 1:14
     *  * @param null
     */
    void batchUpdateResourceUrl(List<Long> sceneIdList);


    /**
     * 根据书籍id和channel获取资源配置页
     * @param adviserBookId
     * @param channelId
     * @return
     */
    ResourcePageVO getResourcePageByBookIdAndChannelId(Long adviserBookId, Long channelId);
    /**
     * 查资源配置
     * @author：zhuyajie
     * @date：2021/4/21 14:42
     *  * @param null
     */
    List<BookGroupServe> getServeListByBookGroupAndSceneIds(List<Long> bookGroupIds, List<Long> sceneIds);

    /**
     * 是否只配了一个应用/作品
     * @author：zhuyajie
     * @date：2021/4/21 15:09
     *  * @param null
     */
    ResourcePageOneServe hasOneResource(Long bookGroupId, Long sceneId, Long wechatUserId, Boolean ignoreRays);

    /**
     * 自有码配置的资源列表
     * @author：zhuyajie
     * @date：2021/4/21 17:52
     *  * @param null
     */
    Map<Long, List<BookGroupServeDTO>> mapSceneServeList(List<Long> sceneIds);

    /**
     * 根据配置的公众号查资源页
     * @author：zhuyajie
     * @date：2021/4/26 9:10
     *  * @param null
     */
    ResourcePage getPageByOfficialScene(Long officialSceneId);

    /**
     * 添加收藏记录
     * @author：zhuyajie
     * @date：2021/4/26 15:36
     *  * @param null
     */
    void addCollectRecord(ResourcePageCollect resourcePageCollect);
    /**
     * 同步渠道资源到H5资源页
     * @author：zhuyajie
     * @date：2021/4/30 10:28
     *  * @param null
     */
    void batchAddResource(List<AddBookGroupServeDTO> list, Long adviserId);

    /**
     * 筛选开启小睿的码
     * @author：zhuyajie
     * @date：2021/4/30 14:26
     *  * @param null
     */
    List<Long> getOpenRaysSceneIds(List<Long> sceneIds);

    /**
     * 批量更新bookgroup对应的sceneId
     * @author：zhuyajie
     * @date：2021/4/30 19:52
     *  * @param null
     */
    void batchUpdateSceneIdByBookGroup(List<AddBookGroupServeDTO> list);

    /**
     * 获取h5页面配了这个资源的二维码集合
     */
    List<Long> getSceneIdsByResourceId(Long resourceId);
    /**
     * 更新书刊id
     * @author：zhuyajie
     * @date：2021/5/11 18:46
     *  * @param null
     */
    void batchUpdateBookId(List<BookSceneIdListDTO> requestDto);

    /**
     * 书刊下开启小睿的资源页资源
     * @author：zhuyajie
     * @date：2021/5/11 19:46
     *  * @param null
     */
    List<BookServeDTO> getBookAndBookGroupServeIds(Long adviserId, Long bookId, Long channelId);


    /**
     * 查用户H5资源页工具列表
     * @author：zhuyajie
     * @date：2021/5/12 17:45
     *  * @param null
     */
    List<ResourcePageTool> getToolListByUser(Long wechatUserId, Long officialAccountsId);

    /**
     * 资源广场模块
     * @author：zhuyajie
     * @date：2021/5/13 11:26
     *  * @param null
     */
    List<Map<String,Object>> getResourceSourceTypeList(Long wechatUserId, Long officialAccountsId);

    /**
     * 查用户学龄段
     * @author：zhuyajie
     * @date：2021/5/13 15:40
     *  * @param null
     */
    Long getUserGrade(Long wechatUserId, Long officialAccountsId);

    /**
     * 添加课程统计数据
     * @author：zhuyajie
     * @date：2021/5/17 15:11
     *  * @param null
     */
    void insertCourseStatistic();

    /**
     * H5首页-根据用户年级查推荐课程
     * @author：zhuyajie
     * @date：2021/5/17 17:07
     *  * @param null
     */
    PageBeanNew<ResourcePageCourseDTO> listCourseByUser(Long wechatUserId, Long officialAccountsId, Integer currentPage, Integer numPerPage);

    /**
     * 查年级标签对应的用户年级
     * @author：zhuyajie
     * @date：2021/5/18 18:58
     *  * @param null
     */
    Long getGradeByGradeLabelId(Long graLabelId);

    /**
     * 查深度标签对应的用户年级
     * @author：zhuyajie
     * @date：2021/5/18 19:20
     *  * @param null
     */
    Long getGradeByDepLabelId(Long depLabelId);
    /**
     * 书刊是否开启小睿
     * @author：zhuyajie
     * @date：2021/5/25 11:00
     *  * @param null
     */
    Boolean isOpenRaysBook(Long bookId, Long channelId, Long adviserId);
    /**
     * 获取用户H5新用户状态
     * @author：zhuyajie
     * @date：2021/5/27 10:39
     *  * @param null
     */
    Map<String, Object> getUserNewState(Long wechatUserId);

    /**
     * 添加新用户记录
     * @author：zhuyajie
     * @date：2021/4/26 15:36
     *  * @param null
     */
    void addNewUserRecord(ResourcePageCollect resourcePageCollect);
    /**
     * 查二维码是否开启小睿
     * @author：zhuyajie
     * @date：2021/5/27 11:52
     *  * @param null
     */
    Boolean isOpenRaysScene(Long sceneId, Long bookGroupId);

    /**
     * 筛选展示开启资源目录展示的图书
     */
    List<String> mapCatalogBook(List<Long> bookIds, Long adviserId);

    List<RaysSceneCatalogDto> listRaysSceneCatalogDto(List<Long> sceneIds);

    /**
     * rays码下面资源数量
     * @param adviserIds
     * @param bookIds
     * @param channelIds
     */
    Map<String, BookGroupServeCountDTO> mapRaysCodeServeCount(List<Long> adviserIds, List<Long> bookIds, List<Long> channelIds);

    /**
     * 获取所有开启“轻工-世纪食记”的书刊
     * @return
     */
    List<ResourcePageVO> getAllBook4OpenFood();

    /**
     * 是否配置有使用付费公众号工具的应用
     * @author：zhuyajie
     * @date：2021/6/10 17:21
     *  * @param null
     */
    Map<String, Object> hasOfficialAccountsTool(Long resourcePageId);

    /**
     * 更新bookId
     * @author：zhuyajie
     * @date：2021/7/2 10:58
     *  * @param null
     */
    void updateBookId(Long bookId, Long sceneId);

    /**
     * 平台端-资源推荐管理-热门课程
     * @author：zhuyajie
     * @date：2021/7/9 15:03
     *  * @param null
     */
    PageBeanNew listRecommendCourse4Pcloud(Integer currentPage, Integer numPerPage, String query);

    /**
     * 平台端-资源推荐管理-教辅、育儿宝库
     * @author：zhuyajie
     * @date：2021/7/9 17:41
     *  * @param null
     */
    PageBeanNew listRecommendResource4Pcloud(Integer currentPage, Integer numPerPage, String query, Integer sourceFrom);

    /**
     * 平台端-资源推荐管理-修改
     * @author：zhuyajie
     * @date：2021/7/9 18:05
     *  * @param null
     */
    void updateRecommendResource4Pcloud(ResourceRecomManage resourceRecomManage);

    /**
     * 查平台端应用作品修改记录
     * @author：zhuyajie
     * @date：2021/7/19 18:20
     *  * @param null
     */
    Map<Long, ResourceRecomManage> mapResourceRecomManage(List<Long> serveIds, String serveType, Integer sourceFrom);

    /**
     * 书下所有应用资源,含完整链接
     * @author：zhuyajie
     * @date：2021/7/27 14:06
     *  * @param null
     */
    List<BookServeDTO> getBookAllServeIdsIncludeUrl(Long adviserId, Long bookId, Long channelId);

    /**
     * 保存导航
     * @author：zhuyajie
     * @date：2021/8/17 16:42
     *  * @param null
     */
    void saveNavigation(NavigationParamDTO navigationParamDTO);
    /**
     * 添加导航图片到图片库
     * @author：zhuyajie
     * @date：2021/8/24 14:46
     *  * @param null
     */
    void addNavigationPic(ResourcePagePic resourcePagePic);
    /**
     * 删除导航图片库图片
     * @author：zhuyajie
     * @date：2021/8/24 14:50
     *  * @param null
     */
    void deleteNavigationPic(Long id);
    /**
     * 查询导航图片库图片
     * @author：zhuyajie
     * @date：2021/8/24 14:51
     *  * @param null
     */
    PageBeanNew<ResourcePagePic> listNavigationPic(Long adviserId, Integer currentPage, Integer numPerPage);

    /**
     * 批量更新栏目排序
     * @author：zhuyajie
     * @date：2021/8/27 19:35
     *  * @param null
     */
    void batchUpdateColumnSeq(List<Long> navigationIds);

    /**
     * 客户端-根据页面id查要弹出的二维码
     * @author：zhuyajie
     * @date：2021/8/23 17:31
     *  * @param null
     */
    ResourcePageItemVO getPopupQrcode4Wechat(Long resourcePageId, Long wechatUserId);

    /**
     * 查资源页信息
     * @author：zhuyajie
     * @date：2021/8/30 11:08
     *  * @param null
     */
    ResourcePageDTO getResourcePageById(Long resourcePageId);
    /**
     * 查询栏目配置的rays工具类型
     * @author：zhuyajie
     * @date：2021/8/30 16:29
     *  * @param null
     */
    List<String> getConfiguredRaysAppTypeCode(Long resourcePageColumnId);

    /**
     * 书刊是否是小学段
     * @author：zhuyajie
     * @date：2021/9/26 14:39
     *  * @param null
     */
    Boolean checkBookChildGrade(Long bookId, Long adviserId, Long channelId);

    /**
     * 客户端-查询书刊推荐资源
     */
    List<RecommendServeVO> getBookRecommendServe(Long wechatUserId, Long bookId, Long adviserId, Long channelId,Long sceneId);

    /**
     *  客户端-查询应用或作品推荐资源
     */
    List<RecommendServeVO> getAppRecommendServe(Long wechatUserId, Long bookId, Long adviserId, Long channelId, Long serveId, String serveType,Long sceneId);
    
    /**
     * @Description  更新落地页类型
     * @Author zhuyajie
     * @Date 13:53 2021/12/1
     **/
    void updateLandingPageType(Long sceneId, Integer landingPageType);
    
    /**
     * @Description  企微落地页配置
     * @Author zhuyajie
     * @Date 14:46 2021/12/2
     **/
    void createWxworkPage(WxworkPageCreateVO wxworkPageCreateVO);

    /**
     * @Description  查企微落地页配置
     * @Author zhuyajie
     * @Date 15:01 2021/12/2
     **/
    WxworkPageVO getWxworkPageByPageId(Long resourcePageId, Boolean isWechat);

    /**
     * @Description  资源页配置
     * @Author zhuyajie
     * @Date 10:44 2021/12/3
     **/
    ResourcePageDTO getResourcePageByQrcode(Long sceneId, Long bookGroupId);

    /**
     * 本书服务页获取资源
     * @param resourcePageId
     * @param wechatUserId
     * @param bookId
     * @param adviserId
     * @param channelId
     * @param enableAdverting
     * @param navigationId
     * @param officialAccountsId
     * @return
     */
    List<ResourceColumnAndServeVO> getColumnAndServeListByPageId4Wechat(Long resourcePageId, Long wechatUserId, Long bookId, Long adviserId, Long channelId, Integer enableAdverting, Long navigationId, Long officialAccountsId);

    List<Integer> getColumnTypeByPageId4Wechat(Long resourcePageId, Long wechatUserId, Long bookId, Long adviserId, Long channelId, Integer enableAdverting, Long navigationId);

    //优化  此处把模块分开调接口  columnType
    List<ResourceColumnAndServeVO> getColumnAndServeListByPageId4WechatV2(Long resourcePageId, Long wechatUserId, Long bookId, Long adviserId, Long channelId,
                                                                          Integer enableAdverting, Long navigationId,Integer columnType, Long officialAccountsId);

    /**
     * 保存分享配置
     * @param param
     * @return
     */
    Integer saveShareConfig(ResourcePageShareParam param);

    /**
     * 获取分享配置
     * @param qrCodeId
     * @return
     */
    ResourcePageShareDto getShareConfig(Long qrCodeId);

    /**
     * @Description  是否配了企微落地页
     * @Author zhuyajie
     * @Date 14:05 2021/12/23
     **/
    Map<Long, Boolean> mapWxworkStateBySceneIds(List<Long> sceneIds);

    List<BookGroupServe> getResourcePageList4Erp(List<Long> sceneIds);

    /**
     * 客户端-斗罗大陆获取配置资源
     * @param wechatUserId
     * @param sceneId
     * @param mapSceneId
     * @return
     */
    List<ResourcePageItemVO> getServerList4Wechat(Long wechatUserId, Long sceneId, Long mapSceneId);
    /**
     * @Description  一码一资源，素材列表
     * @Author zhuyajie
     * @Date 13:39 2022/3/16
     **/
    List<ResourcePageItemResourceVO> listQrOneResourceByBook(Long sceneId, Long wechatUserId);

    Map<Long, BookGroupServeCountDTO> mapQrServeCount(List<Long> sceneIds);

    /**
     * @Description  需要同步到channel的资源
     * @Author zhuyajie
     * @Date 15:59 2022/3/24
     **/
    List<MessagServeDTO> getServeListBySceneId4QrUpdate(Long sceneId);

    /**
     * 根据rays码id查资源页菜单栏数量
     */
    Integer getNavigationCount(Long bookGroupId, Long wechatUserId, Long sceneId);

    /**
     * 删除斗罗首页缓存
     * @param sceneId
     * @param mapSceneIds
     * @param wechatUserId
     */
    void deleteDouluoCache(Long sceneId, List<Long> mapSceneIds, Long wechatUserId);
}
