package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.entity.MultiChannelContentItem;
import com.pcloud.book.group.dao.MultiChannelContentItemDao;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * (MultiChannelContentItem)表数据库访问层
 *
 * @author wubo 
 * @since 2022-06-06 19:12:16
 */
@Repository("multiChannelContentItemDaoImpl")
public class MultiChannelContentItemDaoImpl extends BaseDaoImpl<MultiChannelContentItem> implements MultiChannelContentItemDao {
    public int softDeleteById(Long id) {
             return getSessionTemplate().update(getStatement("softDeleteById"), id);

    }

    @Override
    public List<MultiChannelContentItem> getByMultiChannelContentId(List<Long> multiChannelContentIds) {
        return getSessionTemplate().selectList(getStatement("getByMultiChannelContentId"), multiChannelContentIds);
    }
}
