package com.pcloud.book.group.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 吴博
 * @date 2022/06/06 19:13
 **/
@Data
public class MultiChannelContentItemDTO implements Serializable {
    private static final long serialVersionUID = -55475516566200414L;

    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("多渠道内容id")
    private Long multiChannelContentId;

    @ApiModelProperty("资源唯一id")
    private String itemId;

    @ApiModelProperty("封面")
    private String cover;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("媒体类型。2:图集;4:视频")
    private Integer mediaType;

    @ApiModelProperty("是否置顶")
    private String isTop;

    @ApiModelProperty("视频创建时间戳")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("表示是否审核结束。审核通过或者失败都会返回true，审核中返回false。")
    private Integer isReviewed;

    @ApiModelProperty("表示视频状态。1:已发布; 2:不适宜公开; 4:审核中")
    private String videoStatus;

    @ApiModelProperty("视频播放页面。视频播放页可能会失效，请在观看视频前调用/video/data/获取最新的播放页")
    private String shareUrl;

    @ApiModelProperty("更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    @ApiModelProperty("是否删除")
    private Integer isDelete;


}