package com.pcloud.book.group.entity;

import java.util.Date;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * (MultiChannelContentItem)实体类
 *
 * @author wubo 
 * @since 2022-06-06 19:12:16
 */
@Data
public class MultiChannelContentItem extends BaseEntity {

    private static final long serialVersionUID = -55475516566200414L;
    
    @ApiModelProperty("主键id")
    private Long id;
    
    @ApiModelProperty("多渠道内容id")
    private Long multiChannelContentId;
    
    @ApiModelProperty("资源唯一id")
    private String itemId;
    
    @ApiModelProperty("封面")
    private String cover;
    
    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    
    @ApiModelProperty("更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    
}
