/**
 *
 */
package com.pcloud.book.mq.topic;

import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.book.timecontrol.biz.SelfPlanBiz;
import com.pcloud.facade.tradecenter.dto.TipTopicDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


@Component("tipListener")
@RabbitListener(queues = MQTopicConumer.TIP_FOR_WECHAT_USER)
public class TipListener {

    private final static Logger LOGGER = LoggerFactory.getLogger(TipListener.class);

    @Autowired
    private SelfPlanBiz selfPlanBiz;

    /**
     * 处理个性化定制服务
     */
    @RabbitHandler
    public void onMessage(TipTopicDto tipTopicDto) {
        if (tipTopicDto == null) {
            return;
        }
        // 如果不是文章赞赏直接返回
        if (!"SELF_PLAN".equals(tipTopicDto.getTargetType())) {
            return;
        }
        LOGGER.info("处理个性化定制服务");
        // 存储赞赏支付记录
        long wechatUserId = tipTopicDto.getWechatUserId();
        long planId = tipTopicDto.getTargetId();
        selfPlanBiz.payBack((int) planId);
    }

}
