package com.pcloud.common.core.biz;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.MQQueueConstant;
import com.pcloud.common.core.dto.OperationLogDto;
import com.pcloud.common.exceptions.BizException;

@Service("operationLogQueueBiz")
public class OperationLogQueueBizImpl implements OperationLogQueueBiz {

	@Autowired
	private AmqpTemplate amqpTemplate;

	@Override
	@ParamLog("日志记录QUEUE")
	public void send(OperationLogDto operationLog) throws BizException {
		amqpTemplate.convertAndSend(MQQueueConstant.LOG, operationLog);
	}

}
