package com.pcloud.common.core.biz;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.MQQueueConstant;
import com.pcloud.common.core.dto.WeektaskMessageDto;
import com.pcloud.common.exceptions.BizException;

/**
 * 编辑周任务队列实现
 *
 * @author huanghui
 * @create 2017-09-21 09:33
 **/
@Component("weektaskQueueBiz")
public class WeektaskQueueBizImpl implements WeektaskQueueBiz {

	@Autowired
	private AmqpTemplate amqpTemplate;

	/**
	 * 发送队列
	 */
	@Override
	@ParamLog("红榜任务QUEUE")
	public void sendMessageQueue(WeektaskMessageDto weektaskMessageDto) throws BizException {
		amqpTemplate.convertAndSend(MQQueueConstant.WEEK_TASK, weektaskMessageDto);
	}

}
