package com.pcloud.common.core.constant;

/**
 * Description 作品类型常量类
 * @author PENG
 * @date 2018/4/26
 */
public class ProductTypeConstant {

    /**
     * 普通实体商品
     */
    public static final String COMMON = "COMMON";

    /**
     * 音频
     */
    public static final String AUDIO = "AUDIO";

    /**
     * 视频
     */
    public static final String VIDEO = "VIDEO";

    /**
     * PDF
     */
    public static final String PDF = "PDF";

    /**
     * 相册
     */
    public static final String ALBUM = "ALBUM";

    /**
     * 问答
     */
    public static final String QA = "QA";

    /**
     * 问答资讯
     */
    public static final String QANEWS = "QANEWS";

    /**
     * 书籍
     */
    public static final String BOOK = "BOOK";

    /**
     * 电子书
     */
    public static final String EBOOK = "EBOOK";

    /**
     * 报名
     */
    public static final String MATCH = "MATCH";

    /**
     * 序列号
     */
    public static final String NUMBER = "NUMBER";

    /**
     * 会员
     */
    public static final String MEMBER = "MEMBER";

    /**
     * 题库
     */
    public static final String PRETEST = "PRETEST";

    /**
     * 普通虚拟商品
     */
    public static final String VIRTUAL = "VIRTUAL";

    /**
     * 看一看商品
     */
    public static final String LOOK = "LOOK";

    /**
     * 直播商品
     */
    public static final String LIVE = "LIVE";

    /**
     * 专家审稿
     */
    public static final String REVIEW = "REVIEW";

    /**
     * 工具商品
     */
    public static final String TOOL = "TOOL";

    /**
     * 一对一辅导
     */
    public static final String TUTOR = "TUTOR";

    /**
     * 圈子商品
     */
    public static final String GROUP = "GROUP";

    /**
     * 标准分
     */
    public static final String ZSCORE = "ZSCORE";

    /**
     * 服务商品
     */
    public static final String QS = "QS";

    /**
     * 听力原文资源
     */
    public static final String LISTEN = "LISTEN";

    /**
     * 多格式资源
     */
    public static final String FORMAT = "FORMAT";

    /**
     * 背单词商品
     */
    public static final String WORD = "WORD";

    /**
     * 文章资源
     */
    public static final String ARTICLE = "ARTICLE";

    /**
     * 第三方服务
     */
    public static final String THIRDPARTY = "THIRDPARTY";

    /**
     * 投票
     */
    public static final String VOTE = "VOTE";

    /**
     * 打卡
     */
    public static final String CLOCK = "CLOCK";

    /**
     * 测试
     */
    public static final String TEST = "TEST";

    /**
     * 直播课表
     */
    public static final String SCHEDULE = "SCHEDULE";

    /**
     * 音频
     */
    public static final String AUDIOAPP = "AUDIOAPP";

    /**
     * 答案
     */
    public static final String ANSWER = "ANSWER";

    /**
     * 教育表格
     */
    public static final String EF = "EF";

    /**
     * 绘本配乐库
     */
    public static final String PBMUSIC = "PBMUSIC";

    /**
     * 绘本资源
     */
    public static final String MUSIC = "MUSIC";

    /**
     * 一对一辅导
     */
    public static final String TUTORIAL = "TUTORIAL";

    /**
     * 视频课表
     */
    public static final String VIDEO_SCHEDULE = "VIDEO_SCHEDULE";

    /**
     * 视频课表
     */
    public static final String VIDEO_COURSE = "VIDEO_COURSE";

    /**
     * 题库
     */
    public static final String PRETESTAPP = "PRETESTAPP";

    /**
     * 音频
     */
    public static final String AUDIO_RESOURCE = "AUDIO_RESOURCE";

    /**
     * 问答
     */
    public static final String QA_APP = "QA_APP";

    /**
     * 电子书
     */
    public static final String EBOOK_APP = "EBOOK_APP";

    /**
     * 热门作品类型
     */
    public static final String[] HOT_PRODUCT_TYPE = {QA, PDF, VIDEO, PRETEST};

    /**
     * 资源型作品（免费即可体验）
     */
    public static final String[] RESOURCE_PRODUCT = {AUDIO, VIDEO, PDF, EBOOK, ALBUM, PRETEST, QANEWS,
            FORMAT, WORD, ARTICLE, LISTEN, SCHEDULE, PBMUSIC, TUTORIAL, VIDEO_SCHEDULE};

    /**
     * 参与促销激励作品
     */
    public static final String[] PROMOTION_PRODUCT = {AUDIO, VIDEO, PDF, EBOOK, ALBUM, PRETEST, QANEWS,
            FORMAT, WORD, ARTICLE, LISTEN, PBMUSIC, TUTORIAL, COMMON, QA, BOOK, MATCH, NUMBER, REVIEW, TOOL, QS};

    /**
     * 服务型作品（需要特殊操作方可完成使用）
     */
    public static final String[] SERVICE_PRODUCT = {COMMON, QA, BOOK, MATCH, NUMBER, MEMBER, REVIEW, TOOL, QS, THIRDPARTY};

    /**
     * 应用型作品（伴随应用使用）
     */
    public static final String[] APP_PRODUCT = {LOOK, LIVE, TUTOR, GROUP, ZSCORE, VOTE, CLOCK, TEST, AUDIOAPP, ANSWER,
            EF, MUSIC, VIDEO_COURSE, PRETESTAPP, AUDIO_RESOURCE, QA_APP, EBOOK_APP};

    /**
     * 数据平台埋点型作品
     */
    public static final String[] TRACK_PRODUCT = {COMMON, AUDIO, VIDEO, PDF, EBOOK, BOOK, MATCH, ALBUM, NUMBER, MEMBER,
            PRETEST, QANEWS, REVIEW, TOOL, QS, FORMAT, WORD, ARTICLE};
}
