package com.pcloud.book.applet.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
public class ServeCollectDTO {
    private Long id;

    @ApiModelProperty("读者id")
    private Long wechatUserId;

    @ApiModelProperty("应用id 如答案")
    private Long serveId;

    @ApiModelProperty("服务名称")
    private String serveName;

    @ApiModelProperty("应用类型 1 答案")
    private Integer serveType;

    private Integer serveCode;

    private String serveTypeCode;

    private String serveTypeName;

    private String linkUrl;

    private String picUrl;

    @ApiModelProperty("是否删除  1 删除 0 未删除")
    private Integer isDelete;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    @ApiModelProperty("收藏日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date collectDay;

    @ApiModelProperty("资源是否删除")
    private Integer sourceDelete;

    @ApiModelProperty("是否被收藏")
    private Integer isCollected;
}
