package com.pcloud.book.book.dao;

import com.pcloud.book.book.entity.BookQrcodeWxwork;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * 二维码配置企业微信码(BookQrcodeWxwork)表数据库访问层
 *
 * @author makejava
 * @since 2020-12-22 17:22:19
 */
public interface BookQrcodeWxworkDao extends BaseDao<BookQrcodeWxwork>{


    /**
     * 根据二维码id和类型删除配置
     * @author：zhuyajie
     * @date：2020/12/22 17:29
     *  * @param null
     */
    void deleteByQrcodeIdAndType(Long bookQrcodeId, Integer bookQrcodeType, Integer wxworkQrcodeType);

    /**
     * 根据二维码id和类型查询企业微信码配置
     * @author：zhuyajie
     * @date：2020/12/22 17:32
     *  * @param null
     */
    BookQrcodeWxwork getByQrcodeIdAndType(Long bookQrcodeId, Integer bookQrcodeType, Integer wxworkQrcodeType);

    /**
     * 查询书刊配置的企业微信
     * @author：zhuyajie
     * @date：2020/12/23 16:43
     *  * @param null
     */
    List<BookQrcodeWxwork> getWxworkQrcodeByBook(Long bookId, Long channelId, Long adviserId, Integer wxworkQrcodeType);

    /**
     * 除本书外被勾选的二维码id
     * @author：zhuyajie
     * @date：2021/1/27 15:48
     *  * @param null
     */
    List<Long> getWxworkQrcodeIdsExceptBook(Long bookId, Integer wxworkQrcodeType);
}