package com.pcloud.book.group.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/5/30 15:27
 **/
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AppStatisticsDTO implements Serializable {

    private static final long serialVersionUID = -6223419228204706366L;

    @ApiModelProperty("应用或作品id")
    private Long serveId;

    @ApiModelProperty("应用或作品名称")
    private String serveName;

    @ApiModelProperty("类型")
    private String serveType;

    @ApiModelProperty("应用或作品类型名称")
    private String typeName;

    @ApiModelProperty("应用或作品图片")
    private String image;

    @ApiModelProperty("推送次数")
    private Integer pushCount;

    @ApiModelProperty("点击次数")
    private Integer clickCount;

    @ApiModelProperty("购买次数")
    private Integer buyCount;

    @ApiModelProperty("购买率")
    private Double buyRate;

    @ApiModelProperty("销售总额")
    private Double saleAmount;

    @ApiModelProperty("收益总额")
    private Double incomeAmount;


    public Long getServeId() {
        return serveId;
    }

    public void setServeId(Long serveId) {
        this.serveId = serveId;
    }

    public String getServeName() {
        return serveName;
    }

    public void setServeName(String serveName) {
        this.serveName = serveName;
    }

    public String getServeType() {
        return serveType;
    }

    public void setServeType(String serveType) {
        this.serveType = serveType;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Integer getPushCount() {
        return pushCount;
    }

    public void setPushCount(Integer pushCount) {
        this.pushCount = pushCount;
    }

    public Integer getClickCount() {
        return clickCount;
    }

    public void setClickCount(Integer clickCount) {
        this.clickCount = clickCount;
    }

    public Integer getBuyCount() {
        return buyCount;
    }

    public void setBuyCount(Integer buyCount) {
        this.buyCount = buyCount;
    }

    public Double getBuyRate() {
        return buyRate;
    }

    public void setBuyRate(Double buyRate) {
        this.buyRate = buyRate;
    }

    public Double getSaleAmount() {
        return saleAmount;
    }

    public void setSaleAmount(Double saleAmount) {
        this.saleAmount = saleAmount;
    }

    public Double getIncomeAmount() {
        return incomeAmount;
    }

    public void setIncomeAmount(Double incomeAmount) {
        this.incomeAmount = incomeAmount;
    }

    @Override
    public String toString() {
        return "AppStatisticsDTO{" +
                "serveId=" + serveId +
                ", serveName='" + serveName + '\'' +
                ", serveType='" + serveType + '\'' +
                ", typeName='" + typeName + '\'' +
                ", image='" + image + '\'' +
                ", pushCount=" + pushCount +
                ", clickCount=" + clickCount +
                ", buyCount=" + buyCount +
                ", buyRate=" + buyRate +
                ", saleAmount=" + saleAmount +
                ", incomeAmount=" + incomeAmount +
                '}';
    }
}
