package com.pcloud.book.push.service;

import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.Map;

@FeignClient(value = "pcloud-service-book", qualifier = "pushServiceCloud", path = "book/v1.0/pushService")
@Api(description = "群发消息内部服务")
public interface PushService {

    @ApiOperation("发送群消息")
    @PostMapping("/sendGroupMessage")
    void sendGroupMessage(@RequestBody Map<String, Object> map) throws BizException;

    @ApiOperation("发送早晚报")
    @PostMapping("/sendMorningEveningNews")
    void sendMorningEveningNews(@RequestBody Map<String, Object> map) throws BizException;

}
