package com.pcloud.book.adnews.dao.impl;

import com.pcloud.book.adnews.dao.AdNewsWechatChooseDao;
import com.pcloud.book.adnews.entity.AdNewsWechatChoose;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zhengyongqiang
 * @date 2019/8/7 11:52
 */
@Repository("adNewsWechatChooseDao")
public class AdNewsWechatChooseDaoImpl extends BaseDaoImpl<AdNewsWechatChoose> implements AdNewsWechatChooseDao {

    @Override
    public Integer batchInsert(List<AdNewsWechatChoose> adNewsWechatChooses) {
        return super.getSqlSession().insert(getStatement("batchInsert"),adNewsWechatChooses);
    }

    @Override
    public void deleteAdNewsWechatChooseById(Long adNewsWechatId, Long partyId) {
        Map<String, Object> map = new HashMap<>();
        map.put("adNewsWechatId", adNewsWechatId);
        map.put("partyId", partyId);
        super.getSqlSession().delete(getStatement("deleteAdNewsWechatChooseById"), map);
    }

    @Override
    public void deleteAdNewsWechatChooseByPartyId(Long partyId) {
        Map<String, Object> map = new HashMap<>();
        map.put("partyId", partyId);
        super.getSqlSession().delete(getStatement("deleteAdNewsWechatChooseByPartyId"), map);
    }

    @Override
    public Integer getCountByAdNewsWechatIdsAndPartyId(List<Long> adNewsWechatIds, Long partyId) {
        Map<String, Object> map = new HashMap<>();
        map.put("adNewsWechatIds", adNewsWechatIds);
        map.put("partyId", partyId);
        return super.getSqlSession().selectOne(getStatement("getCountByAdNewsWechatIdsAndPartyId"), map);
    }
}
