package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.AdvertisingBrandBookDao;
import com.pcloud.book.advertising.entity.AdvertisingBrandBook;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2020/4/16 14:01
 **/
@Repository("advertisingBrandBookDao")
public class AdvertisingBrandBookDaoImpl extends BaseDaoImpl<AdvertisingBrandBook> implements AdvertisingBrandBookDao {
    @Override
    public void deleteByBookId(Long bookId) {
        super.getSqlSession().delete(getStatement("deleteByBookId"), bookId);
    }

    @Override
    public Integer batchInsert(List<AdvertisingBrandBook> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public void deleteByBookIds(List<Long> bookIds) {
        super.getSqlSession().delete(getStatement("deleteByBookIds"), bookIds);
    }

    @Override
    public List<AdvertisingBrandBook> getByBookIds(List<Long> bookIds) {
        return super.getSqlSession().selectList(getStatement("getByBookIds"), bookIds);
    }

    @Override
    public List<Long> getBookIdsByAdvertisingBrandId(Long advertisingBrandId) {
        return super.getSqlSession().selectList(getStatement("getBookIdsByAdvertisingBrandId"), advertisingBrandId);
    }

    @Override
    public void deleteByAdvertisingBrandId(Long advertisingBrandId) {
        super.getSqlSession().delete(getStatement("deleteByAdvertisingBrandId"), advertisingBrandId);
    }
}
