package com.pcloud.book.applet.biz.impl;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import com.pcloud.appcenter.app.dto.AppDto;
import com.pcloud.book.applet.biz.AppletBooklistBiz;
import com.pcloud.book.applet.biz.AppletNewsBiz;
import com.pcloud.book.applet.biz.AppletRecordBiz;
import com.pcloud.book.applet.dao.AppletBooklistDao;
import com.pcloud.book.applet.dao.AppletRecordDao;
import com.pcloud.book.applet.dao.AppletRecordDayServeDao;
import com.pcloud.book.applet.dao.AppletRecordServeDao;
import com.pcloud.book.applet.dto.AppletAppOrProductDTO;
import com.pcloud.book.applet.dto.AppletBooklistDTO;
import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.book.applet.dto.AppletOuterBooklistDTO;
import com.pcloud.book.applet.dto.AppletRecordDTO;
import com.pcloud.book.applet.dto.AppletUserBookcaseDTO;
import com.pcloud.book.applet.dto.BookDTO4Booklist;
import com.pcloud.book.applet.entity.AppletRecord;
import com.pcloud.book.applet.entity.AppletRecordDayServe;
import com.pcloud.book.applet.entity.AppletRecordServe;
import com.pcloud.book.applet.enums.AppletRecordTypeEnum;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.consumer.app.AppConsr;
import com.pcloud.book.consumer.channel.QrcodeSceneConsr;
import com.pcloud.book.consumer.resource.ProductConsr;
import com.pcloud.book.group.enums.AppAndProductTypeEnum;
import com.pcloud.book.group.tools.SendWeixinRequestTools;
import com.pcloud.book.rightsSetting.biz.RightsSettingBiz;
import com.pcloud.book.skill.biz.PcloudGroupActivityBiz;
import com.pcloud.book.skill.dto.GroupActivity4AppletDTO;
import com.pcloud.book.util.common.ThreadPoolUtils;
import com.pcloud.channelcenter.wechat.dto.AccountSettingDto;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.BeanUtils;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import com.pcloud.common.utils.string.StringUtil;
import com.pcloud.readercenter.common.enums.YesOrNoNumEnum;
import com.pcloud.resourcecenter.product.dto.ProductDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

/**
 * (AppletRecord)表服务实现类
 *
 * @author makejava
 * @since 2020-08-27 15:49:57
 */
@Service("appletRecordBiz")
public class AppletRecordBizImpl implements AppletRecordBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(AppletRecordBizImpl.class);

    @Autowired
    private AppletRecordDao appletRecordDao;
    @Autowired
    private ProductConsr productConsr;
    @Autowired
    private AppConsr appConsr;
    @Autowired
    private AppletNewsBiz appletNewsBiz;
    @Autowired
    private PcloudGroupActivityBiz pcloudGroupActivityBiz;
    @Autowired
    private AppletBooklistBiz appletBooklistBiz;
    @Autowired
    private RightsSettingBiz rightsSettingBiz;
    @Autowired
    private QrcodeSceneConsr qrcodeSceneConsr;
    @Autowired
    private AppletBooklistDao appletBooklistDao;
    @Autowired
    private AppletRecordDayServeDao appletRecordDayServeDao;
    @Autowired
    private AppletRecordServeDao appletRecordServeDao;

    @Override
    @ParamLog("通过ID查询单条数据")
    public AppletRecord getById(Long id) {
        return appletRecordDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = appletRecordDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)) {
            return pageBeanNew;
        }
        // 加载其它数据

        return pageBeanNew;
    }

    @Override
    @ParamLog("新增足迹埋点")
    @Transactional(rollbackFor = Exception.class)
    public Long insert(AppletRecord appletRecord) {
        insertCheck(appletRecord);
        appletRecordDao.insert(appletRecord);
        //判断日表是否有数据
        AppletRecordDayServe appletRecordDayServe =  new AppletRecordDayServe();
        BeanUtils.copyProperties(appletRecord, appletRecordDayServe);
        AppletRecordServe  appletRecordServe = new AppletRecordServe();
        BeanUtils.copyProperties(appletRecord, appletRecordServe);
        AppletRecordDayServe appletRecordDayServe4Data = appletRecordDayServeDao.getByTypeAndServeId(appletRecord.getWechatUserId(), appletRecord.getRecordType(), appletRecord.getFromId(), DateUtil.today());
        if (null != appletRecordDayServe4Data) {
            //更新
            appletRecordDayServe.setId(appletRecordDayServe4Data.getId());
            appletRecordDayServeDao.update(appletRecordDayServe);
        }else {
            //新增
            appletRecordDayServeDao.insert(appletRecordDayServe);
        }
        //判断总表是否有数据
        AppletRecordServe  appletRecordServe4Data = appletRecordServeDao.getByTypeAndServeId(appletRecord.getWechatUserId(), appletRecord.getRecordType(), appletRecord.getFromId());
        if (null != appletRecordServe4Data) {
            //更新
            appletRecordServe.setId(appletRecordServe4Data.getId());
            appletRecordServeDao.update(appletRecordServe);
        }else {
            //新增
            appletRecordServeDao.insert(appletRecordServe);
        }
        return appletRecord.getId();
    }

    private void insertCheck(AppletRecord appletRecord) {
        if (null == appletRecord) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "appletRecord为空");
        }
        if (null == appletRecord.getRecordType()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "recordType不能为空");
        }
        if (null == appletRecord.getWechatUserId()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "wechatUserId不能为空");
        }
        if (null == appletRecord.getFromId() || StringUtil.isEmpty(appletRecord.getFromName())) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "fromId或fromName为空");
        }
        if (AppletRecordTypeEnum.BOOK.value.equals(appletRecord.getRecordType()) && null !=  appletRecord.getFromId() &&
                (null == appletRecord.getChannelId() || null == appletRecord.getAdviserId())) {
            return;
        }

    }

    @Override
    @ParamLog("修改")
    public void update(AppletRecord appletRecord) {
        if (appletRecord == null || !NumberUtil.isNumber(appletRecord.getId())) {
            throw BizException.PARAM_IS_NULL;
        }
        appletRecordDao.update(appletRecord);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long id) {
        appletRecordDao.deleteById(id);
    }

    @Override
    @ParamLog(value = "我的足迹", isAfterReturn = false)
    public PageBeanNew<AppletRecordDTO> listAppletRecord(Long wechatUserId, String date, List<Integer> recordTypes, String queryName,
                                                         Integer currentPage, Integer numPerPage) {

        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("wechatUserId", wechatUserId);
        paramMap.put("recordTypes", recordTypes);
        paramMap.put("queryName", queryName);
        List<AppletRecordDTO> recordList = null;
        PageBeanNew<AppletRecordDTO> listAppletRecord = new PageBeanNew<>();
        Integer bookType = null;
        if (StringUtil.isEmpty(date)) {
            //从总表中查
            listAppletRecord = appletRecordServeDao.listPageNew(new PageParam(currentPage, numPerPage), paramMap, "listAppletRecord");
            bookType = YesOrNoNumEnum.NO.getValue();
        } else {
            //从天表中查
            paramMap.put("date", date);
            listAppletRecord = appletRecordDayServeDao.listPageNew(new PageParam(currentPage, numPerPage), paramMap, "listAppletRecord");
            bookType = YesOrNoNumEnum.YES.getValue();

        }
        recordList = listAppletRecord.getRecordList();
        fillAppletRecord(recordList, bookType);
        return listAppletRecord;
    }

    @Override
    public List<String> listUnreachableDate(Long wechatUserId) {
        //　获取过去30天所有日期集合
        List<DateTime> dateTimes = DateUtil.rangeToList(DateUtil.offsetDay(new Date(), -30), new Date(), DateField.DAY_OF_YEAR);
        List<Date> reachableDate = new ArrayList<>();
        if (Objects.nonNull(wechatUserId)) {
            reachableDate = appletRecordDao.listReachableDate(wechatUserId);
        }
        List<DateTime> collect = reachableDate.stream().filter(Objects::nonNull).map(DateUtil::beginOfDay).collect(Collectors.toList());
        // 筛选出没有埋点记录的日期
        return dateTimes.stream().filter(x -> !collect.contains(DateUtil.beginOfDay(x))).map(x -> DateUtil.format(x, DatePattern.NORM_DATE_FORMAT)).collect(Collectors.toList());
    }

    private void fillAppletRecord(List<AppletRecordDTO> recordList, Integer bookType) {
        if (ListUtils.isEmpty(recordList)) {
            return;
        }
        //根据不同的类型填充不同的数据
        List<Long> newsIds = recordList.stream().filter(appletRecordDTO -> AppletRecordTypeEnum.NEWS.value.equals(appletRecordDTO.getRecordType())).
                map(appletRecordDTO -> appletRecordDTO.getFromId()).distinct().collect(Collectors.toList());
        List<Long> bookGroupClassifyIds = recordList.stream().filter(appletRecordDTO -> AppletRecordTypeEnum.ADVISER_GROUP.value.equals(appletRecordDTO.getRecordType())).
                map(appletRecordDTO -> appletRecordDTO.getFromId()).distinct().collect(Collectors.toList());
        List<Long> activityGroupIds4Model = recordList.stream().filter(appletRecordDTO -> AppletRecordTypeEnum.MODEL_GROUP.value.equals(appletRecordDTO.getRecordType())).
                map(appletRecordDTO -> appletRecordDTO.getFromId()).distinct().collect(Collectors.toList());
        List<Long> activityGroupIds4Third = recordList.stream().filter(appletRecordDTO -> AppletRecordTypeEnum.THIRD_GROUP.value.equals(appletRecordDTO.getRecordType())).
                map(appletRecordDTO -> appletRecordDTO.getFromId()).distinct().collect(Collectors.toList());
        List<Long> productIds = recordList.stream().filter(appletRecordDTO -> AppletRecordTypeEnum.PRODUCT.value.equals(appletRecordDTO.getRecordType())).
                map(appletRecordDTO -> appletRecordDTO.getFromId()).distinct().collect(Collectors.toList());
        List<Long> appIds = recordList.stream().filter(appletRecordDTO -> AppletRecordTypeEnum.APP.value.equals(appletRecordDTO.getRecordType())).
                map(appletRecordDTO -> appletRecordDTO.getFromId()).distinct().collect(Collectors.toList());
        List<AppletRecordDTO> appletRecordDTOS4Book = recordList.stream().filter(appletRecordDTO -> AppletRecordTypeEnum.BOOK.value.equals(appletRecordDTO.getRecordType())).
                collect(Collectors.toList());
        List<Long> bookRecommendIds = recordList.stream().filter(appletRecordDTO -> AppletRecordTypeEnum.BOOK_RECOMMEND.value.equals(appletRecordDTO.getRecordType())).
                map(appletRecordDTO -> appletRecordDTO.getFromId()).distinct().collect(Collectors.toList());
        List<Long> bookListIds = recordList.stream().filter(appletRecordDTO -> AppletRecordTypeEnum.BOOK_LIST.value.equals(appletRecordDTO.getRecordType())).
                map(appletRecordDTO -> appletRecordDTO.getFromId()).distinct().collect(Collectors.toList());
        //资源map
        Map<Long, AppletNewsDTO> newsDtoMap = new HashMap<>();
        Future<Map<Long, AppletNewsDTO>> newsDtoMapFuture = null;
        Map<Long, GroupActivity4AppletDTO> groupDtoMap4BookGroupClassify = new HashMap<>();
        Future<Map<Long, GroupActivity4AppletDTO>> groupDtoMap4BookGroupClassifyFuture = null;
        Map<Long, GroupActivity4AppletDTO> groupDtoMap4ModelGroup = new HashMap<>();
        Future<Map<Long, GroupActivity4AppletDTO>> groupDtoMap4ModelGroupFuture = null;
        Map<Long, GroupActivity4AppletDTO> groupDtoMap4ThirdGroup = new HashMap<>();
        Future<Map<Long, GroupActivity4AppletDTO>> groupDtoMap4ThirdGroupFuture = null;
        Map<Long, ProductDto> productDtoMap = new HashMap<>();
        Future<Map<Long, ProductDto>> productDtoMapFuture = null;
        Map<Long, AppDto> appDtoMap = new HashMap<>();
        Future<Map<Long, AppDto>> appDtoMappFuture = null;
        Map<Long, AppletUserBookcaseDTO> appletUserBookcaseDTOMap = new HashMap<>();
        Future<Map<Long, AppletUserBookcaseDTO>> appletUserBookcaseDTOMapFuture = null;
        Map<Long, AppletOuterBooklistDTO> appletOuterBooklistDTOMap = new HashMap<>();
        Future<Map<Long, AppletOuterBooklistDTO>> appletOuterBooklistDTOMapFuture = null;
        Map<Long, AppletBooklistDTO> appletBooklistDTOMap = new HashMap<>();
        Future<Map<Long, AppletBooklistDTO>> appletBooklistDTOMapFuture = null;

        if (!ListUtils.isEmpty(newsIds)) {
            newsDtoMapFuture = ThreadPoolUtils.FILL_APPLET_RECORD.submit(() -> appletNewsBiz.getByIds4Record(newsIds));
        }
        if (!ListUtils.isEmpty(bookGroupClassifyIds)) {
            groupDtoMap4BookGroupClassifyFuture = ThreadPoolUtils.FILL_APPLET_RECORD.submit(() -> pcloudGroupActivityBiz.getByIds4NowRecord(bookGroupClassifyIds, AppletRecordTypeEnum.ADVISER_GROUP.value));
        }
        if (!ListUtils.isEmpty(activityGroupIds4Model)) {
            groupDtoMap4ModelGroupFuture = ThreadPoolUtils.FILL_APPLET_RECORD.submit(() -> pcloudGroupActivityBiz.getByIds4NowRecord(activityGroupIds4Model, AppletRecordTypeEnum.MODEL_GROUP.value));
        }
        if (!ListUtils.isEmpty(activityGroupIds4Third)) {
            groupDtoMap4ThirdGroupFuture = ThreadPoolUtils.FILL_APPLET_RECORD.submit(() -> pcloudGroupActivityBiz.getByIds4NowRecord(activityGroupIds4Third, AppletRecordTypeEnum.THIRD_GROUP.value));
        }
        if (!ListUtils.isEmpty(productIds)) {
            productDtoMapFuture = ThreadPoolUtils.FILL_APPLET_RECORD.submit(() -> productConsr.getProBasesByIds(productIds));
        }
        if (!ListUtils.isEmpty(appIds)) {
            appDtoMappFuture = ThreadPoolUtils.FILL_APPLET_RECORD.submit(() -> appConsr.mapByIds4AuditPass(appIds));
        }
        if (!ListUtils.isEmpty(appletRecordDTOS4Book) && YesOrNoNumEnum.NO.getValue().equals(bookType)) {
            appletUserBookcaseDTOMapFuture = ThreadPoolUtils.FILL_APPLET_RECORD.submit(() -> appletRecordServeDao.getBookMap(appletRecordDTOS4Book));
        } else if (!ListUtils.isEmpty(appletRecordDTOS4Book) && YesOrNoNumEnum.YES.getValue().equals(bookType)){
            appletUserBookcaseDTOMapFuture = ThreadPoolUtils.FILL_APPLET_RECORD.submit(() -> appletRecordDayServeDao.getBookMap(appletRecordDTOS4Book));
        }
        if (!ListUtils.isEmpty(bookRecommendIds)) {
            appletOuterBooklistDTOMapFuture = ThreadPoolUtils.FILL_APPLET_RECORD.submit(() -> appletBooklistBiz.getByIds(bookRecommendIds));
        }
        if (!ListUtils.isEmpty(bookListIds)) {
            appletBooklistDTOMapFuture = ThreadPoolUtils.FILL_APPLET_RECORD.submit(() -> appletBooklistBiz.getBookListMap(bookListIds));
        }
        //存储已经删除群的群分类; 精选文章类型并且跳转链接包含qrcode.5rs.me
        Iterator<AppletRecordDTO> iterator = recordList.iterator();
        while (iterator.hasNext()) {
            AppletRecordDTO appletRecordDTO = iterator.next();
            appletRecordDTO.setSourceDelete(YesOrNoNumEnum.NO.getValue());
            if (Objects.equals(AppletRecordTypeEnum.NEWS.value, appletRecordDTO.getRecordType()) && null != newsDtoMap) {
                //填充资讯信息
                filllAppletNews4Record(newsDtoMap, newsDtoMapFuture, appletRecordDTO);
            } else if (Objects.equals(AppletRecordTypeEnum.ADVISER_GROUP.value, appletRecordDTO.getRecordType())) {
                //填充编辑群信息
                fillGroup4Record(groupDtoMap4BookGroupClassify, groupDtoMap4BookGroupClassifyFuture, appletRecordDTO);
            } else if (Objects.equals(AppletRecordTypeEnum.MODEL_GROUP.value, appletRecordDTO.getRecordType())) {
                //填充模板群信息
                fillGroup4Record(groupDtoMap4ModelGroup, groupDtoMap4ModelGroupFuture, appletRecordDTO);
            } else if (Objects.equals(AppletRecordTypeEnum.THIRD_GROUP.value, appletRecordDTO.getRecordType())) {
                //填充第三方群信息
                fillGroup4Record(groupDtoMap4ThirdGroup, groupDtoMap4ThirdGroupFuture, appletRecordDTO);
            } else if (Objects.equals(AppletRecordTypeEnum.PRODUCT.value, appletRecordDTO.getRecordType())) {
                //填充作品信息
                fillProduct4Record(productDtoMap, productDtoMapFuture, appletRecordDTO);
            } else if (Objects.equals(AppletRecordTypeEnum.APP.value, appletRecordDTO.getRecordType())) {
                //填充应用信息
                fillApp4Record(appDtoMap, appDtoMappFuture, appletRecordDTO);
            } else if (Objects.equals(AppletRecordTypeEnum.BOOK.value, appletRecordDTO.getRecordType())) {
                //填充书籍信息
                fillBook4Record(appletUserBookcaseDTOMap, appletUserBookcaseDTOMapFuture, appletRecordDTO);
            } else if (Objects.equals(AppletRecordTypeEnum.BOOK_RECOMMEND.value, appletRecordDTO.getRecordType())) {
                //填充书单推荐信息
                fillAppletOuterBooklist4Record(appletOuterBooklistDTOMap, appletRecordDTO, appletOuterBooklistDTOMapFuture);
            } else if (Objects.equals(AppletRecordTypeEnum.BOOK_LIST.value, appletRecordDTO.getRecordType())) {
                //填充精选书单信息
                fillAppletBooklist4Record(appletBooklistDTOMap, appletBooklistDTOMapFuture, appletRecordDTO);
            }
        }
    }

    private void fillAppletBooklist4Record(Map<Long, AppletBooklistDTO> appletBooklistDTOMap, Future<Map<Long, AppletBooklistDTO>> appletBooklistDTOMapFuture, AppletRecordDTO appletRecordDTO) {
        try {
            appletBooklistDTOMap = appletBooklistDTOMapFuture.get();
        } catch (InterruptedException | ExecutionException e) {
            LOGGER.error("获取精选书单错误: {}==", e);
        }
        if (MapUtil.isEmpty(appletBooklistDTOMap)) {
            appletRecordDTO.setSourceDelete(YesOrNoNumEnum.YES.getValue());
            return;
        }
        AppletBooklistDTO appletBooklistDTO = appletBooklistDTOMap.get(appletRecordDTO.getFromId());
        if (null == appletBooklistDTO) {
            appletRecordDTO.setSourceDelete(YesOrNoNumEnum.YES.getValue());
            return;
        }
        List<BookDTO4Booklist> bookList = appletBooklistDao.getBookBaseByBooklistId(appletBooklistDTO.getId(), 0, 3);
        appletBooklistDTO.setBookDTO4Booklists(ListUtils.isEmpty(bookList) ? new ArrayList<>() : bookList);
        appletRecordDTO.setAppletBooklistDTO(appletBooklistDTO);
    }

    private void fillAppletOuterBooklist4Record(Map<Long, AppletOuterBooklistDTO> appletOuterBooklistDTOMap, AppletRecordDTO appletRecordDTO, Future<Map<Long, AppletOuterBooklistDTO>> appletOuterBooklistDTOMapFuture) {
        try {
            appletOuterBooklistDTOMap = appletOuterBooklistDTOMapFuture.get();
        } catch (InterruptedException | ExecutionException e) {
            LOGGER.error("获取书单推荐错误: {}==", e);
        }
        if (MapUtil.isEmpty(appletOuterBooklistDTOMap)) {
            appletRecordDTO.setSourceDelete(YesOrNoNumEnum.YES.getValue());
            return;
        }
        AppletOuterBooklistDTO outerBooklistDTO = appletOuterBooklistDTOMap.get(appletRecordDTO.getFromId());
        if (null == outerBooklistDTO) {
            appletRecordDTO.setSourceDelete(YesOrNoNumEnum.YES.getValue());
            return;
        }
        appletRecordDTO.setAppletOuterBooklistDTO(outerBooklistDTO);
    }

    private void fillBook4Record(Map<Long, AppletUserBookcaseDTO> appletUserBookcaseDTOMap, Future<Map<Long, AppletUserBookcaseDTO>> appletUserBookcaseDTOMapFuture, AppletRecordDTO appletRecordDTO) {
        try {
            appletUserBookcaseDTOMap = appletUserBookcaseDTOMapFuture.get();
        } catch (InterruptedException | ExecutionException e) {
            LOGGER.error("获取书籍错误: {}==", e);
        }
        if (MapUtil.isEmpty(appletUserBookcaseDTOMap)) {
            appletRecordDTO.setSourceDelete(YesOrNoNumEnum.YES.getValue());
            return;
        }
        AppletUserBookcaseDTO appletUserBookcaseDTO = appletUserBookcaseDTOMap.get(appletRecordDTO.getId());
        if (null == appletUserBookcaseDTO) {
            appletRecordDTO.setSourceDelete(YesOrNoNumEnum.YES.getValue());
            return;
        }
        appletRecordDTO.setAppletUserBookcaseDTO(appletUserBookcaseDTO);
    }

    private void fillGroup4Record(Map<Long, GroupActivity4AppletDTO> groupDtoMap4BookGroupClassify, Future<Map<Long, GroupActivity4AppletDTO>> groupDtoMap4BookGroupClassifyFuture, AppletRecordDTO appletRecordDTO) {
        //填充群信息
        try {
            groupDtoMap4BookGroupClassify = groupDtoMap4BookGroupClassifyFuture.get();
        } catch (InterruptedException | ExecutionException e) {
            LOGGER.error("获取群错误: {}==", e);
        }
        if (MapUtil.isEmpty(groupDtoMap4BookGroupClassify)) {
            appletRecordDTO.setSourceDelete(YesOrNoNumEnum.YES.getValue());
            return;
        }
        GroupActivity4AppletDTO groupActivity4AppletDTO = groupDtoMap4BookGroupClassify.get(appletRecordDTO.getFromId());
        if (null == groupActivity4AppletDTO) {
            appletRecordDTO.setSourceDelete(YesOrNoNumEnum.YES.getValue());
            return;
        }
        appletRecordDTO.setAppletGroupDTO(groupActivity4AppletDTO);
    }

    private void filllAppletNews4Record(Map<Long, AppletNewsDTO> newsDtoMap, Future<Map<Long, AppletNewsDTO>> newsDtoMapFuture, AppletRecordDTO appletRecordDTO) {
        //填充资讯信息
        try {
            newsDtoMap = newsDtoMapFuture.get();
        } catch (InterruptedException | ExecutionException e) {
            LOGGER.error("获取资讯错误: {}==", e);
        }
        if (MapUtil.isEmpty(newsDtoMap)) {
            appletRecordDao.updateDeleteState(appletRecordDTO.getFromId(), appletRecordDTO.getRecordType());
            return;
        }
        AppletNewsDTO appletNewsDTO = newsDtoMap.get(appletRecordDTO.getFromId());
        if (null == appletNewsDTO || Objects.equals(YesOrNoNumEnum.YES.getValue(), appletNewsDTO.getIsDelete())) {
            appletRecordDTO.setSourceDelete(YesOrNoNumEnum.YES.getValue());
            return;
        }
        appletNewsDTO.setNewsType(appletNewsDTO.getType());
        appletNewsDTO.setNewsName(appletRecordDTO.getFromName());
        appletRecordDTO.setAppletNewsDTO(appletNewsDTO);
        appletRecordDTO.setShowState(appletNewsDTO.getShowState() ? YesOrNoNumEnum.YES.getValue() : YesOrNoNumEnum.NO.getValue());
        appletRecordDTO.setIsDelete(appletNewsDTO.getIsDelete());
    }

    private void fillApp4Record(Map<Long, AppDto> appDtoMap, Future<Map<Long, AppDto>> appDtoMappFuture, AppletRecordDTO appletRecordDTO) {
        try {
            appDtoMap = appDtoMappFuture.get();
        } catch (InterruptedException | ExecutionException e) {
            LOGGER.error("获取app错误: {}==", e);
        }
        if (MapUtil.isEmpty(appDtoMap)) {
            appletRecordDTO.setSourceDelete(YesOrNoNumEnum.YES.getValue());
            return;
        }
        AccountSettingDto accountSettingDto;
        AppDto appDto = appDtoMap.get(appletRecordDTO.getFromId());
        AppletAppOrProductDTO appletAppOrProductDTO = new AppletAppOrProductDTO();
        if (appDto == null || appDto.getIsDelete()) {
            appletRecordDTO.setSourceDelete(YesOrNoNumEnum.YES.getValue());
            return;
        }
        if (!StringUtil.isEmpty(appletRecordDTO.getLinkUrl()) && appletRecordDTO.getLinkUrl().contains("qrcode.5rs.me") && "ARTICLE".equals(appDto.getTypeCode())) {
            appletRecordDTO.setSourceDelete(YesOrNoNumEnum.YES.getValue());
            return;
        }
        appletAppOrProductDTO.setServeName(appDto.getTitle());
        appletAppOrProductDTO.setServePic(appDto.getSquareImg());
        appletAppOrProductDTO.setServeTypeCode(appDto.getTypeCode());
        appletAppOrProductDTO.setServeTypeName(appDto.getTypeName());
        accountSettingDto = qrcodeSceneConsr.getWechatInfo(appDto.getChannelId());
        if (null == accountSettingDto) {
            appletRecordDTO.setSourceDelete(YesOrNoNumEnum.YES.getValue());
            return;
        }
        String resultLinkUrl = SendWeixinRequestTools.splitUrl(accountSettingDto, appletRecordDTO.getLinkUrl());
        appletAppOrProductDTO.setResultUrl(resultLinkUrl);
        if (!StringUtil.isEmpty(appDto.getTurnUrl())){
            appletAppOrProductDTO.setHasThirdLink(true);
        } else {
            appletAppOrProductDTO.setHasThirdLink(false);
        }
        appletAppOrProductDTO.setServeType(AppAndProductTypeEnum.APP.value);
        appletAppOrProductDTO.setServeId(appletRecordDTO.getFromId());
        appletRecordDTO.setAppletAppOrProductDTO(appletAppOrProductDTO);
    }

    private void fillProduct4Record(Map<Long, ProductDto> productDtoMap, Future<Map<Long, ProductDto>> productDtoMapFuture, AppletRecordDTO appletRecordDTO) {
        try {
            productDtoMap = productDtoMapFuture.get();
        } catch (InterruptedException | ExecutionException e) {
            LOGGER.error("获取product错误: {}==", e);
        }
        if (MapUtil.isEmpty(productDtoMap)) {
            appletRecordDTO.setSourceDelete(YesOrNoNumEnum.YES.getValue());
            return;
        }
        AccountSettingDto accountSettingDto;
        ProductDto productDto = productDtoMap.get(appletRecordDTO.getFromId());
        AppletAppOrProductDTO appletAppOrProductDTO = new AppletAppOrProductDTO();
        if (productDto == null || YesOrNoNumEnum.YES.getValue().equals(productDto.getIsDelete())) {
            appletRecordDTO.setSourceDelete(YesOrNoNumEnum.YES.getValue());
            return;
        }
        appletAppOrProductDTO.setServeName(productDto.getProductName());
        appletAppOrProductDTO.setServePic(productDto.getCoverImg());
        if (productDto.getProductTypeDto() != null) {
            appletAppOrProductDTO.setServeTypeCode(productDto.getProductTypeDto().getTypeCode());
            appletAppOrProductDTO.setServeTypeName(productDto.getProductTypeDto().getTypeName());
        }
        //获取channelId,/C1404/product/display/10234028?adviserId=1001587&proType=MEMBER&source_type=QRCODE
        Long channelId = null;
        String url = appletRecordDTO.getLinkUrl();
        if (!StringUtil.isEmpty(url) && url.contains("/C") && !url.startsWith("https")) {
            url = url.substring(url.indexOf("/C") + 2);
            url = url.substring(0, url.indexOf("/"));
            if (!StringUtil.isEmpty(url)) {
                channelId = Long.valueOf(url);
            }
        }
        if (null != channelId) {
            accountSettingDto = qrcodeSceneConsr.getWechatInfo(channelId);
            if (null != accountSettingDto) {
                String resultLinkUrl = SendWeixinRequestTools.splitUrl(accountSettingDto, productDto.getTurnUrl());
                appletAppOrProductDTO.setResultUrl(resultLinkUrl);
            }
        } else {
            appletAppOrProductDTO.setResultUrl(appletRecordDTO.getLinkUrl());
        }
        if (!StringUtil.isEmpty(productDto.getSkipUrl())){
            appletAppOrProductDTO.setHasThirdLink(true);
        } else {
            appletAppOrProductDTO.setHasThirdLink(false);
        }
        appletAppOrProductDTO.setServeType(AppAndProductTypeEnum.PRODUCT.value);
        appletAppOrProductDTO.setServeId(appletRecordDTO.getFromId());
        appletRecordDTO.setAppletAppOrProductDTO(appletAppOrProductDTO);
    }


}