package com.pcloud.book.applet.biz.impl;

import com.pcloud.book.applet.biz.AppletStatisticBiz;
import com.pcloud.book.applet.contants.AppletConstants;
import com.pcloud.book.applet.dao.AppletUserDao;
import com.pcloud.book.applet.dto.AppletStatisticDTO;
import com.pcloud.book.applet.dto.AppletUserCountDTO;
import com.pcloud.book.applet.entity.AppletUser;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.book.biz.BookAdviserBiz;
import com.pcloud.book.consumer.channel.QrcodeSceneConsr;
import com.pcloud.book.consumer.reader.ReaderConsr;
import com.pcloud.book.group.biz.BookGroupBiz;
import com.pcloud.book.group.enums.JoinGroupTypeEnum;
import com.pcloud.common.utils.cache.redis.JedisClusterUtils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @ClassName com.pcloud.book.applet.biz.impl.AppletStatisticBizImpl
 * @Author zhuyajie
 * @Description 小程序数据统计
 * @Date 2020/7/28 17:28
 * @Version 1.0
 **/
@Component
public class AppletStatisticBizImpl implements AppletStatisticBiz{

    @Autowired
    private QrcodeSceneConsr qrcodeSceneConsr;
    @Autowired
    private AppletUserDao appletUserDao;
    @Autowired
    private BookAdviserBiz bookAdviserBiz;
    @Autowired
    private BookGroupBiz bookGroupBiz;
    @Autowired
    private ReaderConsr readerConsr;

    @Override
    public void addRecord(AppletUser appletUser) {
        if (null == appletUser.getWechatUserId() || null == appletUser.getAccountSettingId()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"参数缺失");
        }
        appletUserDao.insert(appletUser);
    }

    @Override
    public AppletStatisticDTO getStatisticByAgentAndTime(Long agentId, String startTime, String endTime) {
        AppletStatisticDTO appletStatisticDTO = new AppletStatisticDTO();
        Long accountSettingId = qrcodeSceneConsr.getAccountSettingIdByAgentId(agentId);
        if (null == accountSettingId) {
            return new AppletStatisticDTO();
        }
        //扫小程序码次数/人数
        AppletUserCountDTO userCountDTO = appletUserDao.getUserCount(startTime, endTime, accountSettingId);
        appletStatisticDTO.setScanCount(userCountDTO.getCount());
        appletStatisticDTO.setScanUserCount(userCountDTO.getUserCount());
        //出版社下书刊数量
        Integer bookCount = bookAdviserBiz.getBookCountByAgentAndTime(agentId, startTime, endTime);
        appletStatisticDTO.setBookCount(bookCount);
        //小程序用户数量
        Integer userCount = readerConsr.getAccountUserCountByTime(accountSettingId, startTime, endTime);
        appletStatisticDTO.setUserCount(userCount);
        return appletStatisticDTO;
    }

    @Override
    public AppletStatisticDTO getStatisticByAgent(Long agentId) {
        Long accountSettingId = qrcodeSceneConsr.getAccountSettingIdByAgentId(agentId);
        if (null == accountSettingId) {
            return new AppletStatisticDTO();
        }
        AppletStatisticDTO appletStatisticDTO = JedisClusterUtils.hgetJson2Class(AppletConstants.APPLET_AGENT_STATISTIC, agentId.toString(), AppletStatisticDTO.class);
        if (null != appletStatisticDTO) {
            return appletStatisticDTO;
        }
        appletStatisticDTO = new AppletStatisticDTO();
        //扫小程序码次数/人数
        AppletUserCountDTO userCountDTO = appletUserDao.getUserCount(null, null, accountSettingId);
        appletStatisticDTO.setScanCount(userCountDTO.getCount());
        appletStatisticDTO.setScanUserCount(userCountDTO.getUserCount());
        //出版社下书刊数量
        Integer bookCount = bookAdviserBiz.getBookCount(agentId);
        appletStatisticDTO.setBookCount(bookCount);
        //出版社小睿书数量
        Integer rayBookCount = bookGroupBiz.getBookGroupCountByAgent(JoinGroupTypeEnum.XIAORUI.getCode(), agentId);
        appletStatisticDTO.setRaysBookCount(rayBookCount);
        //小程序用户数量
        Integer userCount = readerConsr.getAccountUserCountByTime(accountSettingId, null, null);
        appletStatisticDTO.setUserCount(userCount);
        JedisClusterUtils.hset2Json(AppletConstants.APPLET_AGENT_STATISTIC, agentId.toString(), appletStatisticDTO);
        JedisClusterUtils.expire(AppletConstants.APPLET_AGENT_STATISTIC, 10 * 60);
        return appletStatisticDTO;
    }
}
