package com.pcloud.book.applet.service.impl;

import com.pcloud.book.applet.biz.AnswerSubscribeBiz;
import com.pcloud.book.applet.biz.AppletBooklistBiz;
import com.pcloud.book.applet.biz.AppletBookClassifyBiz;
import com.pcloud.book.applet.biz.AppletNewsBiz;
import com.pcloud.book.applet.biz.AppletRecordStatisBiz;
import com.pcloud.book.applet.biz.AppletThirdResourcesStaticBiz;
import com.pcloud.book.applet.biz.ServeCollectBiz;
import com.pcloud.book.applet.dto.AppletNewsVO;
import com.pcloud.book.applet.dto.AppletOuterBookDTO;
import com.pcloud.book.applet.dto.PcloudGroupActivityDTO;
import com.pcloud.book.applet.dto.ServeCollectDTO;
import com.pcloud.book.applet.service.AppletService;
import com.pcloud.book.rightsSetting.biz.RightsSettingBiz;
import com.pcloud.book.skill.biz.PcloudGroupActivityBiz;
import com.pcloud.book.skill.entity.PcloudGroupActivity;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.ResponseHandleUtil;

import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.ApiParam;

import java.util.List;

/**
 * @ClassName com.pcloud.book.applet.service.impl.AppletServiceImpl
 * @Author zhuyajie
 * @Description 小程序内部服务
 * @Date 2020/4/26 20:04
 * @Version 1.0
 **/
@RestController("appletService")
@RequestMapping("appletService")
public class AppletServiceImpl implements AppletService {

    @Autowired
    private AppletNewsBiz appletNewsBiz;

    @Autowired
    private PcloudGroupActivityBiz pcloudGroupActivityBiz;
    @Autowired
    private AppletBooklistBiz appletBooklistBiz;
    @Autowired
    private AppletBookClassifyBiz appletBookClassifyBiz;
    @Autowired
    private AnswerSubscribeBiz answerSubscribeBiz;
    @Autowired
    private AppletThirdResourcesStaticBiz appletThirdResourcesStaticBiz;
    @Autowired
    private ServeCollectBiz serveCollectBiz;
    @Autowired
    private RightsSettingBiz rightsSettingBiz;
    @Autowired
    private AppletRecordStatisBiz appletRecordStatisBiz;


    @Override
    @GetMapping("getNewsById")
    public ResponseEntity<ResponseDto<AppletNewsVO>> getNewsById(Long newsId) {
        return ResponseHandleUtil.toResponse(appletNewsBiz.getNewsVOById(newsId));
    }

    @Override
    @GetMapping("getGroupActivityById")
    public ResponseEntity<ResponseDto<PcloudGroupActivityDTO>> getGroupActivityById(@RequestParam("id") Long id){
        PcloudGroupActivity pcloudGroupActivity = pcloudGroupActivityBiz.getById(id);
        PcloudGroupActivityDTO newData = new PcloudGroupActivityDTO();
        BeanUtils.copyProperties(pcloudGroupActivity,newData);
        return ResponseHandleUtil.toResponse(newData);
    }

    @Override
    @GetMapping("getOuterBookById")
    public ResponseEntity<ResponseDto<AppletOuterBookDTO>> getOuterBookById(@RequestParam("outerBookId") Long outerBookId){
        return ResponseHandleUtil.toResponse(appletBooklistBiz.getOuterBookById(outerBookId));
    }

    @Override
    @GetMapping("createBaseClassifysToAgent")
    public void createBaseClassifysToAgent(@RequestParam("agentId") @ApiParam Long agentId){
        appletBookClassifyBiz.createBaseClassifysToAgent(agentId);
    }

    @Override
    @GetMapping("checkAnswerUpdate")
    public void checkAnswerUpdate(){
        answerSubscribeBiz.checkAnswerUpdate();
    }

    @Override
    @GetMapping("sendAppletMsg4Answer")
    public void sendAppletMsg4Answer(){
        answerSubscribeBiz.sendAppletMsg4Answer();
    }

    @Override
    @GetMapping("getAppletThirdResourceStatic")
    public void getAppletThirdResourceStatic(@RequestParam(value = "isAll", required = false) @ApiParam Integer isAll) {
        appletThirdResourcesStaticBiz.getAppletThirdResourceStatic(isAll);
    }

    @Override
    @PostMapping("getList4Collect")
    public ResponseEntity<ResponseDto<List<ServeCollectDTO>>> getList4Collect(@RequestBody List<ServeCollectDTO> serveCollects) {
        return ResponseHandleUtil.toResponse(serveCollectBiz.getList4Collect(serveCollects));
    }

    @Override
    @GetMapping("getPopupCount")
    public ResponseEntity<ResponseDto<Integer>> getPopupCount(@RequestParam("wechatUserId") Long wechatUserId,
                                                       @RequestParam("bookId") Long bookId,
                                                       @RequestParam("popupType") Integer popupType){
        return ResponseHandleUtil.toResponse(rightsSettingBiz.getPopupCount(wechatUserId, bookId, popupType));
    }

    @Override
    @ApiOperation("删除指定周的统计数据")
    @GetMapping("deleteWeekAppletRecordStatis")
    public void deleteWeekAppletRecordStatis(@RequestParam("mondayDate")String mondayDate) {
        appletRecordStatisBiz.deleteWeekAppletRecordStatis(mondayDate);
    }

    @Override
    @ApiOperation("统计指定周的数据")
    @GetMapping("addWeekAppletRecordStatis")
    public void addWeekAppletRecordStatis(@RequestParam(value = "mondayDate",required = false)String mondayDate) {
        appletRecordStatisBiz.addWeekAppletRecordStatis(mondayDate);
    }
}
