package com.pcloud.book.consumer.promotion;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.promotion.fission.dto.UpdateQrDTO;
import com.pcloud.promotion.groupFission.service.GroupFissionService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component("promotionConsr")
public class PromotionConsr {
    /**
     * logger
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(PromotionConsr.class);


    @Autowired
    private GroupFissionService groupFissionService;

    @ParamLog("获取备用二维码")
    public String getSpareQr() throws BizException {
        try {
            return ResponseHandleUtil.parseResponse(groupFissionService.getSpareQr(), String.class);
        } catch (Exception e) {
            LOGGER.warn("获取备用二维码失败:" + e.getMessage(), e);
        }
        return "";
    }

    @ParamLog("同步更新二维码")
    public void updateQrUrl(UpdateQrDTO updateQrDTO) throws BizException {
        try {
            groupFissionService.updateQrUrl(updateQrDTO);
        } catch (Exception e) {
            LOGGER.warn("同步更新二维码失败:" + e.getMessage(), e);
        }
    }
}
