package com.pcloud.book.group.biz;

import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.book.entity.Book;
import com.pcloud.book.group.dto.AgentStatisticsInfoDTO;
import com.pcloud.book.group.dto.AltAndCountDTO;
import com.pcloud.book.group.dto.AppStatisticsDTO;
import com.pcloud.book.group.dto.BackgroundGroupQrcodeDTO;
import com.pcloud.book.group.dto.BookAppletSceneDTO;
import com.pcloud.book.group.dto.BookGroupClassifyDTO;
import com.pcloud.book.group.dto.BookGroupCountDTO;
import com.pcloud.book.group.dto.BookGroupCreateDTO;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.dto.BookGroupKeywordResourceDTO;
import com.pcloud.book.group.dto.BookGroupSceneDTO;
import com.pcloud.book.group.dto.BookGroupServeCountDTO;
import com.pcloud.book.group.dto.BookGroupStatistic4AgentDTO;
import com.pcloud.book.group.dto.BookGroupStatisticsDTO;
import com.pcloud.book.group.dto.BookServeDTO;
import com.pcloud.book.group.dto.BookServeResourceDTO;
import com.pcloud.book.group.dto.ChangeQrCodeTypeDto;
import com.pcloud.book.group.dto.ClassifyKeywordDTO;
import com.pcloud.book.group.dto.CountAndTimeDTO;
import com.pcloud.book.group.dto.ErpBookGroupDTO;
import com.pcloud.book.group.dto.ErpGroupQrcodeDTO;
import com.pcloud.book.group.dto.GroupCipherDTO;
import com.pcloud.book.group.dto.GroupQrcodeDTO;
import com.pcloud.book.group.dto.GroupStoreMyPayDto;
import com.pcloud.book.group.dto.GroupUseDTO;
import com.pcloud.book.group.dto.JoinGroupCipherDTO;
import com.pcloud.book.group.dto.LabelUserCountDTO;
import com.pcloud.book.group.dto.LargeTempletDTO;
import com.pcloud.book.group.dto.OwnAltQrcodeInfoDTO;
import com.pcloud.book.group.dto.PersonalQrcodeDTO;
import com.pcloud.book.group.dto.QrcodeNameAndProIdDTO;
import com.pcloud.book.group.dto.ResourceBrowseParamDto;
import com.pcloud.book.group.dto.SelfBookGroupStDTO;
import com.pcloud.book.group.dto.SelfBookGroupStParamDTO;
import com.pcloud.book.group.dto.SelfRobotBookGroupDTO;
import com.pcloud.book.group.dto.SelfRobotUserDTO;
import com.pcloud.book.group.dto.SelfRobtParamDTO;
import com.pcloud.book.group.dto.TopAgentBookGroupDTO;
import com.pcloud.book.group.dto.UserBookBaseInfoDTO;
import com.pcloud.book.group.dto.UserSelectParamDTO;
import com.pcloud.book.group.entity.BookGroup;
import com.pcloud.book.group.entity.BookGroupServe;
import com.pcloud.book.group.entity.WxWechatUserCorrelation;
import com.pcloud.book.group.vo.BookGroupAnalysisParam;
import com.pcloud.book.group.vo.BookGroupAnalysisVO;
import com.pcloud.book.group.vo.FriendsVO;
import com.pcloud.book.group.vo.GroupIncomeStaticParamVO;
import com.pcloud.book.group.vo.GroupScanTrendParamVO;
import com.pcloud.book.group.vo.GroupScanTrendVO;
import com.pcloud.book.group.vo.GroupStatisticVO;
import com.pcloud.book.group.vo.ListBookGroup4ChannelParamVO;
import com.pcloud.book.group.vo.ResourcesStatisticVO;
import com.pcloud.book.group.vo.StatisticVO;
import com.pcloud.book.group.vo.TotalRescourceDataVO;
import com.pcloud.book.group.vo.UserBookInfoVO;
import com.pcloud.book.group.vo.WxGroupStatisticVO;
import com.pcloud.book.keywords.vo.ListKeywordVO;
import com.pcloud.book.skill.entity.PcloudGroupActivity;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.dto.StoreFlowInfoDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.wechatgroup.group.dto.GroupUserCountDTO;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

/**
 * Description 社群书群二维码业务逻辑层接口
 * Created by PENG on 2019/4/17.
 */
public interface BookGroupBiz {

    String updateNoISBNBookGeneratorQrcode( MultipartFile file );
    /**
     * 查询编辑是否有此社群书
     * @param bookId
     * @param channelId
     * @param adviserId
     * @return
     */
    BookGroupDTO getDTOByBookId(Long bookId, Long channelId, Long adviserId);
    /**
     * 创建社群书时生成群二维码
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @throws BizException
     */
    BookGroup createBookGroupAfterCreateBook(Long bookId, Long channelId, Long adviserId, Integer addType, Long sceneId, Integer joinGroupType,
                                             Integer jumpType, String jumpUrl) throws BizException;

    /**
     * 获取社群书群二维码信息
     * @param bookGroupId 群二维码ID
     * @return
     * @throws BizException
     */
    BookGroupDTO getBookGroupInfo(Long bookGroupId) throws BizException;

    /**
     * 获取社群书名和封面
     * @param bookGroupId 群二维码ID
     * @return
     * @throws BizException
     */
    BookGroupDTO getBookInfo(Long bookGroupId) throws BizException;

    /**
     * 批量获取社群书群二维码信息
     * @param bookGroupIds 群二维码ID列表
     * @return
     * @throws BizException
     */
    Map<Long, BookGroupDTO> getBookGroupInfoByIds(List<Long> bookGroupIds) throws BizException;

    /**
     * 根据bookId和AdviserId批量获取社群书基本信息
     */
    List<BookGroupDTO> getBookGroupInfoByBookIdAndAdviserId(List<Long> bookIds, List<Long> adviserIds);

    /**
     * 获取社群书群二维码信息
     * @param bookGroupId 群二维码ID
     * @return
     * @throws BizException
     */
    BookGroupDTO getBookGroupInfo4Wechat(Long bookGroupId) throws BizException;

    /**
     * 获取社群书群二维码信息
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @return
     * @throws BizException
     */
    BookGroupDTO getBookGroupInfoByBookId(Long bookId, Long channelId, Long adviserId, Integer addType, Long sceneId, Integer joinGroupType,
                                          Integer jumpType, String jumpUrl) throws BizException;

    /**
     * 更新群二维码信息
     * @param bookGroup 群二维码实体
     * @throws BizException
     */
    void updateBookGroup(BookGroup bookGroup) throws BizException;

    /**
     * 根据书刊ID删除
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @throws BizException
     */
    void deleteByBookId(Long bookId, Long channelId, Long adviserId) throws BizException;

    /**
     * 根据书刊ID恢复
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @throws BizException
     */
    void recoverByBookId(Long bookId, Long channelId, Long adviserId) throws BizException;

    /**
     * 关联社群码和社群书
     * @param bookId      书刊ID
     * @param bookGroupId 社群码ID
     * @param adviserId   编辑ID
     * @throws BizException
     */
    void linkBookGroup(Long bookId, Long bookGroupId, Long adviserId) throws BizException;

    /**
     * 根据社群码ID获取书名
     * @param bookGroupId 社群码ID
     * @return
     * @throws BizException
     */
    Map<String, Object> getBookNameByBookGroupId(Long bookGroupId) throws BizException;

    /**
     * 获取社群书列表(编辑)
     * @param paramMap  参数Map
     * @param pageParam 分页参数
     * @param adviserId 编辑ID
     * @return
     * @throws BizException
     */
    PageBean listBookGroup4Adviser(Map<String, Object> paramMap, PageParam pageParam, Long adviserId) throws BizException;

    /**
    * @description 获取社群书列表(运营)
    * @author 戴兴
    * @date 2019/7/23 15:39
    */
    PageBean listBookGroup4Channel(Long channelId, ListBookGroup4ChannelParamVO listBookGroup4ChannelParamVO);

    /**
     * 获取社群书列表(编辑)
     * @param paramMap 参数Map
     * @return
     * @throws BizException
     */
    List<BookDto> listSimpleBookGroup4Adviser(Map<String, Object> paramMap) throws BizException;

    /**
     * 获取社群书列表(编辑)
     * @param paramMap  参数Map
     * @param pageParam 分页参数
     * @return
     * @throws BizException
     */
    PageBean listSimpleBookGroup4Adviser(Map<String, Object> paramMap, PageParam pageParam) throws BizException;

    /**
     * 获取未创建社群码的书刊列表
     * @param paramMap  参数Map
     * @param pageParam 分页参数
     * @param adviserId 编辑ID
     * @return
     * @throws BizException
     */
    PageBean listBook4CreateBookGroup(Map<String, Object> paramMap, PageParam pageParam, Long adviserId) throws BizException;

    /**
     * @Author:lili
     * @Desr:获取群二维码名称以及商品id
     * @Date:2019/4/18 9:57
     */
    QrcodeNameAndProIdDTO getQrcodeNameAndProId(Long bookGroupId) throws BizException;

    /**
     * @Author:lili
     * @Desr:获取排序方式
     * @Date:2019/4/19 14:57
     */
    Integer getRankType(Long bookGroupId) throws BizException;

    /**
     * @Author:lili
     * @Desr:更新排序方式
     * @Date:2019/4/19 14:58
     */
    void updateRankType(Long bookGroupId, Integer rankType) throws BizException;

    /**
     * 编辑获取社群码总数量
     * @param adviserId 编辑ID
     * @return
     * @throws BizException
     */
    Map<String, Object> getTotalBookGroupCount(Long adviserId) throws BizException;

    /**
     * @Author:lili
     * @Desr:获取备用二维码
     * @Date:2019/5/13 15:09
     */
    String getSpareQr(Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:根据二维码获取社群码基本信息
     * @Date:2019/5/27 17:59
     */
    BookGroupDTO getBaseInfoBySceneId(Long sceneId);

    /**
    * @description 更新个人二维码
    * @author 戴兴
    * @date 2019/8/7 16:30
    */
    void updatePersonQrcode(PersonalQrcodeDTO personalQrcodeDTO);

    /**
     * @Author:lili
     * @Desr:是否是特殊的出版社
     * @Date:2019/5/28 11:14
     */
    Boolean isSpecialAgent(Long agentId);

    /**
     * @Author:lili
     * @Desr:是否有社群码
     * @Date:2019/5/30 16:36
     */
    Boolean isHaveQrcode(Long bookId, Long channelId, Long adviserId);


    /**
     * 获取应用作品统计
     * @param currentPage
     * @param numPerPage
     * @param bookGroupId
     * @param qrcodeId
     * @return
     */
    PageBeanNew<AppStatisticsDTO> getAppStatistics(Integer currentPage, Integer numPerPage, Long bookGroupId, Long qrcodeId, Long partyId);

    /**
     * 社群码导出
     * @param paramMap
     */
    void exportGroupQrcode4Adviser(Map<String, Object> paramMap, Long adviserId);

    /**
     * 根据bookId获取社群书分类等统计
     */
    StatisticVO getBookGroupStatistics(Long bookId);

    /**
     * 根据bookId获取社群书分类和关键词等统计信息
     */
    List<ClassifyKeywordDTO> getBookGroupKeywordStatistics(Long bookId);

    /**
     * 更新是否显示书名
     */
    void updateIsShowBookName(Boolean isShowBookName, Long partyId);

    /**
     * 获取是否显示书名
     */
    Boolean getIsShowBookName(Long partyId);

    /**
     * 删除社群码
     */
    void deleteBookGroup(Long bookGroupId);

    /**
     * 删除社群书不删除现代纸书
     * by sjh 20191119
     */
    void deleteBookGroup4Adviser(Long bookGroupId);

    /**
     * 根据社群码id获取个人二维码信息
     */
    OwnAltQrcodeInfoDTO getOwnAltQrcodeInfoDTOByBookGroupId(Long wechatUserId, Long bookGroupId);
    /**
     * 根据分类id获取个人二维码信息
     */
    OwnAltQrcodeInfoDTO getOwnAltQrcodeInfoDTOByClassifyId(Long wechatUserId, Long classifyId);

    /**
     * 根据群二维码id获取个人二维码信息
     */
    OwnAltQrcodeInfoDTO getOwnAltQrcodeInfoDTOByQrcodeId(Long wechatUserId, Long qrcodeId);

    /**
     * 获取暗号状态
     */
    Integer getCipherState(String cipher);

    /**
     * 更新状态为已使用
     */
    void updateCipherStateToUsed(String cipher, String wxId);

    /**
     * 获取个人二维码方式群已使用和未使用数量
     */
    GroupUseDTO getGroupUse(List<String> altIds);

    /**
     * 获取所有的大类分类
     */
    List<LargeTempletDTO> getAllLargTemplet();

    /**
     * 根据微信id和机器人id获取分类集合
     */
    List<JoinGroupCipherDTO> getClassifyIdsByWxIdAndAltId(String wxId,String altId);

    /**
     * 获取暗号基本信息
     */
    GroupCipherDTO getJoinGroupCipher(String cipher);

    /**
     * 为信息流批量获取社群书基本信息
     */
    Map<Long, StoreFlowInfoDto> getFlowInfoByBookGroupIds(List<Long> bookGroupIds);

    /**
     * 获取指定条数社群书基本信息
     */
    Map<Long, StoreFlowInfoDto> getBookGroupInfoByChannelId(Long channelId, Integer itemNum);

    /**
     * 知识商城获取社群书信息
     */
    PageBeanNew<StoreFlowInfoDto> listBookGroup4KnowledgeMall(Long channelId, int currentPage, int numPerPage);
    /**
     * 获取用户购买或者参与过的社群书信息
     */
    PageBeanNew<GroupStoreMyPayDto> getUserBrowseGroup4KnowLedgeMall(Long channelId, Long wechatUserId, Integer currentPage, Integer numPerPage);

    /**
     * 获取社群码相关数据
     */
    BookGroupStatisticsDTO getBookGroupStatisByBookGroupId(Long bookGroupId);

    /**
     * 收益统计
     */
    PageBeanNew<ResourcesStatisticVO> getGroupIncomeStatic(GroupIncomeStaticParamVO groupIncomeStaticParamVO, Long adviserId);

    /**
     * 社群码浏览趋势图
     */
    List<GroupScanTrendVO> getGroupScanTrend(GroupScanTrendParamVO groupScanTrendParamVO, Long adviserId);

    /**
     * 社群码分类统计
     */
    PageBeanNew<GroupStatisticVO> getClassifyStatistic(Long bookGroupId, Long adviserId, Integer currentPage, Integer numPerPage);

    /**
     * 社群码分类的微信群统计
     */
    List<WxGroupStatisticVO> getQrcodeStatistic(Long bookGroupId, Long classifyId, Long adviserId);

    /**
     * 资源数据统计
     */
    TotalRescourceDataVO getTotalRescourceData(Long bookGroupId,Long adviserId, Long classifyId, Long qrcodeId, String type);

    /**
     * 资源数据导出
     */
    Map<String, String> exportRescourceIncomeData(Long bookGroupId,Long adviserId);

    /**
     * 获取资源浏览数据
     */
    Map<Long, Long> getResourcesBrowseCount(ResourceBrowseParamDto resourceBrowseParamDto);

    /**
     *日加好友人数
     * @param bookGroupId
     * @param startDate
     * @param endDate
     * @return
     */
    Map<String, Integer> getBookGroupFriendsCountByDay(Long bookGroupId, String startDate, String endDate);
    /**
     * 好友数据统计列表
     * @param bookGroupId
     * @return
     */
    PageBeanNew<FriendsVO> listPageFriendsStatistic(Long bookGroupId, Integer currentPage, Integer numPerPage);

    /**
     * 批量新增资源配置
     *
     * @param partyId
     * @param bookGroupServes
     */
    void batchAddBookGroupServe(Long partyId, List<BookGroupServe> bookGroupServes);

    /**
     * 删除资源配置
     *
     * @param id
     */
    void deleteBookGroupServe(Long id);

    /**
     * 获取资源配置集合
     *
     * @param bookGroupId
     * @return
     */
    List<BookGroupServe> getBookGroupServeList(Long bookGroupId);

    /**
     * 客户端获取资源配置集合
     * @param bookGroupId
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<BookGroupServe> getBookGroupServeList4Wechat(Long bookGroupId, Integer currentPage, Integer numPerPage);

    /**
     * 获取资源配置集合
     * @param bookGroupId
     * @return
     */
    BookServeResourceDTO getBookGroupServeListByBookGroupId(Long bookGroupId);

    /**
     * 获取社群码暗号
     */
    String getBookGroupCipher();

    /**
     * 批量更新资源配置
     * @param partyId
     * @param bookGroupServes
     */
    void batchUpdateBookGroupServe(Long partyId, List<BookGroupServe> bookGroupServes);

    /**
     * 将1v1旧数据的关键词全部都干掉，有应用或作品的挂在社群书配置资源里面
     */
    void dealSelfBookGroupKeywordToServer();

    /**
     * 补充1v1旧数据的暗号
     */
    void fillSelfBookGroupCipher();

    /**
     * 将之前的配置资源取的社群码运营更新为应用本身的运营
     */
    void dealBookGroupServerChannel();

    /**
     * 社群书分析
     * @param bookGroupAnalysisParam
     * @return
     */
    PageBeanNew<BookGroupAnalysisVO> listPageBookGroupAnalysis(BookGroupAnalysisParam bookGroupAnalysisParam);

    /**
     * 社群书分析--导出
     * @param bookGroupAnalysisParam
     */
    void exportBookGroupAnalysis(BookGroupAnalysisParam bookGroupAnalysisParam, Long partyId);
    /**
     * 社群书关键词关联的资源（关键词及1v1配置资源）
     */
    List<BookGroupKeywordResourceDTO> getKeyWordResourceByBookGroup(Long bookGroupId);

    /**
     * 社群书下二维码
     */
    List<Long> getQrcodeIdsByBookGroupId(Long bookGroupId);

    /**
     * 更新是否邀请入群
     */
    void updateIsInviteGroup(BookGroup bookGroup);

    /**
     * 更新1v1是否有更新
     */
    void updateIsSomeUpdate(BookGroup bookGroup);

    /**
     * 新增推送更新
     */
    void addPushBookGroupUpdate(BookGroup bookGroup);

    /**
     * 推送更新
     */
    void pushBookGroupUpdate();

    /**
     * 获取是否能推送更新的各个状态
     */
    Map<String,Boolean> getStatesForPushUpdate(Long bookGroupId);

    /**
     * 上架所有的个人号配置资源
     */
    void dealBookGroupServeOldOnShelves();

    /**
     * 1v1社群码下用户
     * @param bookGroupId
     * @return
     */
    List<String> getFriendIdsByBookGroupId(Long bookGroupId);

    /**
     * 个人号读者统计
     * @param selfRobtParamDTO
     * @return
     */
    PageBeanNew<SelfRobotUserDTO> listPageFriendInfo(SelfRobtParamDTO selfRobtParamDTO);

    /**
     * 根据类型获取社群书数量
     */
    Integer getBookGroupCountByJoinGroupType(Integer joinGroupType);

    /**
     * 获取个人号累计加好友人数
     */
    Integer getAddFriendCount();

    /**
     * 根据时间段获取个人号加好友人数
     */
    List<CountAndTimeDTO> getAddFriendCountByTime(Integer timeType, String startTime, String endTime);

    /**
     * 获取出版社创建社群书数量排行
     */
    List<TopAgentBookGroupDTO> getTopAgentCreateBookGroup(Integer joinGroupType, Integer top, Boolean isSpecial);

    /**
     * 补充社群书的出版社id
     */
    void fillAgentIdForBookGroup();

    /**
     * 获取所有已建分类的1v1的社群码
     */
    List<Long> get1v1HasClassifyBookGroupIds();

    /**
     * 获取个人号读者专业或深度分布
     */
    List<LabelUserCountDTO> getUserLabelDistribution(Integer largeTemplet, Integer type);

    /**
     * 获取出版社个人号统计信息
     */
    PageBeanNew<AgentStatisticsInfoDTO> getAgentStatisticsInfo(Long agentId, Boolean isSpecial, Integer currentPage, Integer numPerPage);

    /**
     * 导出出版社个人号统计信息
     */
    void exportAgentStatisticsInfo(Long partyId, Long agentId, Boolean isSpecial);

    /**
     * 按时间获取资源服务点击量趋势
     */
    Map<String, List<CountAndTimeDTO>> getServeClickTendencyList(Long bookGroupId, List<String> dateList);

    /**
     * 个人号社群书统计
     */
    PageBeanNew<SelfBookGroupStDTO> getSelfBookGroupStatistics(SelfBookGroupStParamDTO selfBookGroupStParamDTO);

    /**
     * 导出个人号社群书统计
     */
    void exportSelfBookGroupStatistics(SelfBookGroupStParamDTO selfBookGroupStParamDTO,String systemCode,Long partyId);

    /**
     * 根据小号批量获取服务社群书数量
     */
    Map<String,Integer> getBookGroupCountMapByAltIds(List<String> altIds);

    /**
     * 获取小号社群书数量
     */
    Integer getSerBookGroupCountByAltIds(List<String> altIds);

    /**
     * 出版社关联的个人号以及个人号的社群书数量
     */
    List<AltAndCountDTO> getAltAndCountDTOListByAgentId(Long agentId);

    /**
     * 平台端 个人号群发用户查询
     * @param userSelectParamDTO
     * @return
     */
    PageBeanNew<UserBookInfoVO> listUser4SelfPush(UserSelectParamDTO userSelectParamDTO);

    /**
     * 编辑端 个人号群发用户查询
     * @param userSelectParam
     * @return
     */

    PageBeanNew<UserBookInfoVO> listUser4SelfPushByAdvise(Map<String,Object> userSelectParam);

    /**
     * 根据类型获取社群书id集合
     */
    List<Long> getBookGroupIdsByJoinGroupType(Integer joinGroupType);

    /**
     * 获取随机码
     */
    String getRandomCode(Long wechatUserId);
    /**
     * 查小号的好友id
     * @param altId
     * @param bookIds
     * @return
     */
    public List<String> getFriendIdListByBookAndRobot(String altId, List<Long> bookIds);

    /**
     * 用户扫码书刊名称
     * @param altId
     * @param wxUserIdList
     * @return
     */
    Map<String,List<UserBookBaseInfoDTO>> mapUserScanBook(String altId, List<String> wxUserIdList);

    /**
     * 转换二维码
     */
    Long changeQrCodeType(ChangeQrCodeTypeDto changeQrCodeTypeDto);

    Long getChangeQrChangeTarget(Long originId, String originType);

    /**
     * 获取1v1社群书列表
     */
    PageBeanNew<BookGroupDTO> getListBookGroup4Adviser(Map<String, Object>paramMap, PageParam pageParam);

    /**
     * 获取关联1v1书刊
     */
    PageBeanNew<BookGroupDTO> getAssocBookGroupByAppInfo(Map<String, Object>paramMap, PageParam pageParam);

    /**
     * 获取1v1关联社群书数量和名称
     */
    List<BookGroupDTO> getAssocBookGroupByServeInfo(Long adviserId,Long serveId,String serveType);

    /**
     * 更新社群码定制出版社状态
     * @param id
     * @param belongSpecialAgent
     */
    public void updateSpecialState(Long id, Boolean belongSpecialAgent);

    /**
     * 获取应用或作品关联的社群书数量
     * @param dtos
     * @return
     */
    List<BookGroupCountDTO> getAssocBookGroupCount(List<BookGroupCountDTO> dtos);

    /**
     * 用户最近关联的社群书
     */
    Long getLatestCipherBookGroup(String altId, String wxUserId);

    /**
     * 出版社根据bookId获取社群码统计信息
     * @param bookId
     * @return
     */
    BookGroupStatistic4AgentDTO getBookGroupStatisticsByAgent(Long bookId,Long agentId,Long adviserId,Long channelId);

    /**
     * 获取群分类关键词数据
     * @param classifyId
     * @return
     */
    List<ListKeywordVO> getClassifyKeywordStatistic(Long classifyId);
	
    /**
     * ERP创建社群二维码
     */
    ErpBookGroupDTO createGroupQrcode4Erp(ErpGroupQrcodeDTO erpGroupQrcodeDTO);


    /**
     * 新增微信用户和rays系统用户关联关系
     */
    void createWxWechatUserCorrelation(Long wechatUserId, WxWechatUserCorrelation wxWechatUserCorrelation);

    /**
     * 根据用户和社群书id获取个人号信息
     * @param wxUserId
     * @param bookGroupId
     * @return
     */
    SelfRobotBookGroupDTO getSelfRobotBookGroupInfoByUser(String wxUserId, Long bookGroupId);

    /**
     * 共读活动-好友列表
     * @param userSelectParamDTO
     * @return
     */
    PageBeanNew<UserBookInfoVO> listUser4ReadingActivity(UserSelectParamDTO userSelectParamDTO);


    public void createBookGroupAppletUrl(Long bookGroupId,Long bookId, Long channelId, Long adviserId);

    /**
     *根据小程序ID获取
     * @param appletId
     * @return
     */
    public BookAppletSceneDTO getBookGroupAppletByAppletId(String appletId);

    /**
     * 获取小程序码
     * @param bookGroupId
     * @param requestIp
     * @return
     */
    public BookAppletSceneDTO getBookGroupAppletByBookGroupId(Long bookGroupId, String requestIp);

    /**
     * 更新小睿分类
     * @param book
     */
    public void updateBookGroupRaysClassify(Book book);

    /**
     * 根据临时书刊id获取社群书id
     * @param raysBookId
     * @return
     */
    public Long getBookGroupId4OldData(Long raysBookId);

    /**
     * 获取小程序中信息
     * @param wechatUserId
     * @param scene
     */
    BookGroupDTO getByAppletScene(Long wechatUserId, String scene);

    /**
     * 获取小睿社群书和现代纸书所配资源
     * @param adviserId
     * @param bookId
     * @param channelId
     * @param wechatUserId
     * @return
     */
    PageBeanNew<BookServeDTO> getBookAndBookGroupServeList(Long adviserId, Long bookId, Long channelId, Long wechatUserId);

    void fillCollect4Book(Long wechatUserId, List<BookServeDTO> serveDTOList);

    void removeCanNotBuy( List<BookServeDTO> list );

    /**
     * 获取小睿社群书和现代纸书所配资源id
     * @param adviserId
     * @param bookId
     * @param channelId
     * @return
     */
    List<BookServeDTO> getBookAndBookGroupServeIds(Long adviserId, Long bookId, Long channelId);

    BookAppletSceneDTO getBookAppletBySceneId(Long sceneId);

    public void fillBookServe(List<BookServeDTO> serveDTOList);

    /**
     * 获取图书信息-首页
     * @param adviserId
     * @param channelId
     * @param bookId
     * @return
     */
    Map<String,Object> getBookBaseInfo4Applet(Long adviserId, Long channelId, Long bookId);

    PageBeanNew<BookGroupClassifyDTO> getBookGroupClassifyByAdviserId(Long adviserId, String classify, Integer currentPage , Integer numPerPage);

    /**
     * 1V1社群书是否开启小睿流程
     * @author：zhuyajie
     * @date：2020/6/5 11:20
     *  * @param null
     */
    void updateBookGroupOpenWeapp(Long bookGroupId, Boolean openWeapp);

    /**
     * 创建独立活码群社群码
     * @author：zhuyajie
     * @date：2020/5/28 11:36
     *  * @param null
     */
    Long createSingleBookGroup(BookGroup bookGroup, Long adviserId);

    /**
     * 更新小睿关联社群书
     * @author：zhuyajie
     * @date：2020/5/29 19:21
     *  * @param null
     */
    void updateRelatedBookGroup(Long bookGroupId, Long relatedBookGroupId);

    /**
     * 获取独立活码群社群码列表
     * @author：zhuyajie
     * @date：2020/6/1 12:43
     *  * @param null
     */
    PageBeanNew<BookGroupDTO> listSingleBookGroup4Adviser(String name, Integer currentPage, Integer numPerPage, Long adviserId);

    /**
     * 资源服务类型旧数据处理
     * @author：zhuyajie
     * @date：2020/6/16 11:09
     *  * @param null
     */
    void updateBookServeTypeCode();
    /**
     * 小程序书刊资源数量
     * @author：zhuyajie
     * @date：2020/6/15 18:12
     *  * @param null
     */
    Map<String,Integer> mapServeCount4Applet(List<Long> bookIds);

    /**
     * 批量获取书下的资源数
     * @param adviserIds
     * @param bookIds
     * @param channelIds
     * @return
     */
    Map<String, BookGroupServeCountDTO> mapBookGroupServeCount(List<Long> adviserIds, List<Long> bookIds, List<Long> channelIds);

    /**
     * 批量获取书下的资源数
     * @param adviserIds
     * @param bookIds
     * @param channelIds
     * @return
     */
    Map<String, BookGroupServeCountDTO> mapBookGroupQrcodeServeCount(List<Long> adviserIds, List<Long> bookIds, List<Long> channelIds, Integer groupType);

    String getGroupNewsMaterialById(Long bookGroupQrcodeId, Long classifyId, Integer useType, Long groupActivityId);

    String updateMediaId4Activity(String url, PcloudGroupActivity pcloudGroupActivity);

    List<GroupQrcodeDTO> getMigrateGroup(List<String> groups);

    /**
     * 出版社下扫码量最多的社群码
     * @author：zhuyajie
     * @date：2020/8/6 9:32
     *  * @param null
     */
    BookGroupDTO getMaxScanCountBookGroup(Long agentId, Integer joinGroupType);

    /**
     * 获取小睿社群书列表(小睿独立管理端)
     * @author：zhuyajie
     * @date：2020/7/22 11:06
     *  * @param null
     */
    PageBean listBookGroup4AppletAgent(Map<String, Object> paramMap, PageParam pageParam);

    /**
     * 根据编辑获取对应的小程序
     * @author：zhuyajie
     * @date：2020/7/28 16:29
     *  * @param null
     */
    public Long getAccountSettingByAdviser(Long adviserId);

    /**
     * 出版社社群书数量
     * @author：zhuyajie
     * @date：2020/7/29 10:40
     *  * @param null
     */
    Integer getBookGroupCountByAgent(Integer joinGroupType, Long agentId);

    List<BookServeDTO> getBookAndBookGroupServeIds4Price(Long adviserId, Long bookId, Long channelId);

    /**
     * 根据bookgroupId查小睿书
     * @author：zhuyajie
     * @date：2020/9/28 10:51
     *  * @param null
     */
    BookGroupDTO getRayBookByBookGroupId(Long bookGroupId);

    List<BookGroupDTO> getBookGroupsByBookIds(List<Long> bookIds, List<Long> adviserIds, List<Long> channelIds);
    /**
     * 判断是否是小睿链接
     * @author：zhuyajie
     * @date：2020/10/21 17:20
     *  * @param null
     */
    Boolean checkRayUrl(String url);

    /**
     * 根据sceneId或bookGroupId查书刊信息
     * @author：zhuyajie
     * @date：2020/10/29 19:39
     *  * @param null
     */
    Map<String, Object> getBookBase4Applet(Long sceneId, Long bookGroupId);

    /**
     * 根据社群书id获取公众号二维码信息（H5跳公众号流程）
     * @author：zhuyajie
     * @date：2020/12/7 10:50
     *  * @param null
     */
    BookGroupSceneDTO getSceneQrcodeByBookGroupId(Long bookGroupId);

    /**
     *社群码下载选择样式
     */
    BackgroundGroupQrcodeDTO getBackgroundGroupQr(BackgroundGroupQrcodeDTO backgroundGroupQrcodeDTO);

    List<BookServeDTO> getBookAndBookGroupServeIdsFive(Long adviserId, Long bookId, Long channelId);

    /**
     * 书刊创建RAYS码-支持1对多
     * @author：zhuyajie
     * @date：2020/12/14 10:20
     *  * @param null
     */
    BookGroup createBookGroup(BookGroupCreateDTO bookGroupCreateDTO);

    /**
     * 获取社群码下配的资源
     * @author：zhuyajie
     * @date：2020/12/16 17:55
     *  * @param null
     */
    List<BookServeDTO> getServeListByBookGroupId(Long bookGroupId, Long channelId);
}
