package com.pcloud.book.group.dao;

import com.pcloud.book.group.entity.BookAppletScene;
import com.pcloud.common.core.dao.BaseDao;

/**
 * 社群书小程序码
 */
public interface BookAppletSceneDao extends BaseDao<BookAppletScene> {

    /**
     * 根据小程序id获取关联信息
     * @param appletId
     * @return
     */
    public BookAppletScene getByAppletId(String appletId);

    /**
     * 根据bookGroupId获取
     * @param bookGroupId
     * @return
     */
    public BookAppletScene getByBookGroupId(Long bookGroupId);

    /**
     * 更新分类
     * @param raysClassifyId
     * @param bookGroupId
     */
    public void updateRaysClassifyIdByBookGroupId(Long raysClassifyId,Long bookGroupId);

    /**
     * 删除
     * @param bookGroupId
     */
    public void deleteByBookGroupId(Long bookGroupId);

    BookAppletScene getBySceneId(Long sceneId);
}
