package com.pcloud.book.group.vo;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.math.BigDecimal;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lily
 * @date 2019/4/17 14:17
 */
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ClassifyVO implements Serializable {

    private Long id;

    @ApiModelProperty("分类")
    private String classify;

    @ApiModelProperty("二维码地址")
    private String qrcodeUrl;

    @ApiModelProperty("分类介绍")
    private String classifyIntroduce;

    @ApiModelProperty("价格")
    private BigDecimal price;

    @ApiModelProperty("换群数量")
    private Integer changeNumber;

    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("运营标识")
    private Long channelId;

    @ApiModelProperty("社群二维码标识")
    private Long bookGroupId;

    @ApiModelProperty("商品标识")
    private Long productId;

    @ApiModelProperty("规格标识")
    private Long productSpecId;

    @ApiModelProperty("排序")
    private Integer rank;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("进群方式：1群二维码，2客服机器人")
    private Integer joinGroupType;

    @ApiModelProperty("城市编码")
    private String cityCode;

    @ApiModelProperty("城市名称")
    private String cityName;

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public Integer getRank() {
        return rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getClassify() {
        return classify;
    }

    public void setClassify(String classify) {
        this.classify = classify;
    }

    public String getQrcodeUrl() {
        return qrcodeUrl;
    }

    public void setQrcodeUrl(String qrcodeUrl) {
        this.qrcodeUrl = qrcodeUrl;
    }

    public String getClassifyIntroduce() {
        return classifyIntroduce;
    }

    public void setClassifyIntroduce(String classifyIntroduce) {
        this.classifyIntroduce = classifyIntroduce;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Integer getChangeNumber() {
        return changeNumber;
    }

    public void setChangeNumber(Integer changeNumber) {
        this.changeNumber = changeNumber;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(Long bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public Long getProductSpecId() {
        return productSpecId;
    }

    public void setProductSpecId(Long productSpecId) {
        this.productSpecId = productSpecId;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Integer getJoinGroupType() {
        return joinGroupType;
    }

    public void setJoinGroupType(Integer joinGroupType) {
        this.joinGroupType = joinGroupType;
    }

    @Override
    public String toString() {
        return "ClassifyVO{" +
                "id=" + id +
                ", classify='" + classify + '\'' +
                ", qrcodeUrl='" + qrcodeUrl + '\'' +
                ", classifyIntroduce='" + classifyIntroduce + '\'' +
                ", price=" + price +
                ", changeNumber=" + changeNumber +
                ", bookId=" + bookId +
                ", channelId=" + channelId +
                ", bookGroupId=" + bookGroupId +
                ", productId=" + productId +
                ", productSpecId=" + productSpecId +
                ", rank=" + rank +
                ", createUser=" + createUser +
                ", joinGroupType=" + joinGroupType +
                '}';
    }
}
