/**
 * 
 */
package com.pcloud.common.utils.nginx;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;

/**
 * @描述：Nginx工具类
 * @作者：songx
 * @创建时间：2016年12月3日,下午6:06:07
 * @版本：1.0
 */
public class NginxUtils {
	
	 /**
	  * 在很多应用下都可能有需要将用户的真实IP记录下来，这时就要获得用户的真实IP地址，在JSP里，获取客户端的IP地
	  * 址的方法是：request.getRemoteAddr()，这种方法在大部分情况下都是有效的。但是在通过了Apache,Squid等
	  * 反向代理软件就不能获取到客户端的真实IP地址了。
	  * 但是在转发请求的HTTP头信息中，增加了X－FORWARDED－FOR信息。用以跟踪原有的客户端IP地址和原来客户端请求的服务器地址。
	  * @param request
	  * @return
	  */
	public static String getClientIp(HttpServletRequest request) {
		String ip = request.getHeader("X-Forwarded-For");
		if (StringUtils.isNotEmpty(ip) && !"unKnown".equalsIgnoreCase(ip)) {
			// 多次反向代理后会有多个ip值，第一个ip才是真实ip
			int index = ip.indexOf(",");
			if (index != -1) {
				return ip.substring(0, index);
			} else {
				return ip;
			}
		}
		ip = request.getHeader("X-Real-IP");
		if (StringUtils.isNotEmpty(ip) && !"unKnown".equalsIgnoreCase(ip)) {
			return ip;
		}
		return request.getRemoteAddr();
	}
	
	/**
	  * 获得浏览器请求头中的User-Agent
	  * @param request
	  * @return
	  */
	public static String getClientUA(HttpServletRequest request) {
		String userAgent = request.getHeader("user-agent");
		return userAgent;
	}

}
