package com.pcloud.book.adnews.dao.impl;

import com.pcloud.book.adnews.dao.AdNewsWechatDao;
import com.pcloud.book.adnews.entity.AdNewsWechat;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zhengyongqiang
 * @date 2019/8/7 11:52
 */
@Repository("adNewsWechatDao")
public class AdNewsWechatDaoImpl extends BaseDaoImpl<AdNewsWechat> implements AdNewsWechatDao {
    @Override
    public boolean checkRepeat(String wechatName, Long adviserId) {
        Map<String,Object> map = new HashMap<>();
        map.put("wechatName",wechatName);
        map.put("adviserId",adviserId);
        return super.getSqlSession().selectOne(getStatement("checkRepeat"),map);
    }

    @Override
    public Integer batchInsert(List<AdNewsWechat> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"),list);
    }

    @Override
    public boolean existsAdNewsWechat(Long adviserId) {
        Map<String,Object> map = new HashMap<>();
        map.put("adviserId",adviserId);
        return super.getSqlSession().selectOne(getStatement("existsAdNewsWechat"),map);
    }

    @Override
    public List<AdNewsWechat> getListByAdviserId(Long adviserId) {
        return super.getSqlSession().selectList(getStatement("getListByAdviserId"),adviserId);
    }
}
