package com.pcloud.book.group.dao;

import com.pcloud.book.group.dto.BookGroupCountDTO;
import com.pcloud.book.group.dto.BookGroupServeCountDTO;
import com.pcloud.book.group.entity.BookGroupApp;
import com.pcloud.book.group.entity.BookGroupServe;
import com.pcloud.book.group.vo.BookGroupServeCountVO;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

public interface BookGroupServeDao extends BaseDao<BookGroupServe> {
    Integer batchInsert(List<BookGroupServe> bookGroupServes);

    List<BookGroupServe> getListByBookGroupId(Long bookGroupId);

    void deleteByBookGroupId(Long bookGroupId);

    List<BookGroupServe> getListByServerType(String serveType);

    void updateShortUrl(Long id, String shortUrl);

    List<BookGroupServe> getProductServeList();

    List<BookGroupApp> getAllAppServe();

    Integer getCountByBookGroupId(Long bookGroupId);

    List<BookGroupServe> getListByBookGroupIds(List<Long> bookGroupIds);

    void deleteByBookGroupIds(List<Long> bookGroupIds);

    /**
     * 获取应用或作品关联的社群书数量
     * @param serveIds
     * @param serveType
     * @param adviserId
     * @return
     */
    List<BookGroupCountDTO> getCountByServeIds(List<Long> serveIds, String serveType, Long adviserId);
    /**
     * typecode为空的记录-旧数据处理
     * @author：zhuyajie
     * @date：2020/6/16 11:13
     *  * @param null
     */
    List<BookGroupServe> getTypeCodeNull(String serveType);

    /**
     * 批量更新
     * @author：zhuyajie
     * @date：2020/6/16 13:42
     *  * @param null
     */
    void batchUpdate(List<BookGroupServe> bookGroupServeList);
    /**
     * 书刊资源数量-小程序
     * @author：zhuyajie
     * @date：2020/6/16 15:23
     *  * @param null
     */
    List<BookGroupServeCountVO> getServeList4Applet(List<Long> bookIds);

    /**
     * 批量获取书下的资源数
     * @param adviserIds
     * @param bookIds
     * @param channelIds
     * @return
     */
    Map<String, BookGroupServeCountDTO> mapBookGroupServeCount(List<Long> adviserIds, List<Long> bookIds, List<Long> channelIds);

    /**
     * 批量获取书下的资源数
     * @param adviserIds
     * @param bookIds
     * @param channelIds
     * @return
     */
    Map<String, BookGroupServeCountDTO> mapBookGroupQrcodeServeCount(List<Long> adviserIds, List<Long> bookIds, List<Long> channelIds, Integer joinGroupType);

}
