package com.pcloud.book.advertising.facade;


import com.pcloud.book.advertising.entity.AdvertisingBmRegister;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.*;
import org.codehaus.jackson.JsonParseException;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * 报名
 */
@Api("报名应用FACADE接口类")
public interface BmFacade {

    /**
     * 获取报名应用选项类型
     * @param token 用户身份信息
     * @return
     * @throws PermissionException
     * @throws BizException
     * @throws JsonParseException
     */
    @ApiOperation(value = "获取报名应用选项类型",httpMethod = "GET")
    @RequestMapping(value = "getOptionType",method = RequestMethod.GET)
    ResponseDto<?> getOptionType(@RequestHeader("token") String token)
            throws PermissionException, BizException, JsonParseException;

    /**
     * 获取报名应用选项数据类型
     * @param token 用户身份信息
     * @return
     * @throws PermissionException
     * @throws BizException
     * @throws JsonParseException
     */
    @ApiOperation(value = "获取报名应用选项数据类型",httpMethod = "GET")
    @RequestMapping(value = "/getOptionDataType",method = RequestMethod.GET)
    ResponseDto<?> getOptionDataType(@RequestHeader("token") String token)
            throws PermissionException, BizException, JsonParseException;

    /**
     * 用户提交表单
     * @param userInfo 用户身份信息
     * @param bmRegister 用户实体
     * @return
     * @throws PermissionException
     * @throws BizException
     * @throws JsonParseException
     * postman
     */
    @ApiOperation(value = "用户提交表单", httpMethod = "POST")
    @RequestMapping(value = "/userSubmit4Wechat", method = RequestMethod.POST)
    ResponseDto<?> userSubmit4Wechat(@CookieValue("userInfo") String userInfo,
                                     @RequestBody @ApiParam AdvertisingBmRegister bmRegister)
            throws PermissionException, BizException, JsonParseException;

    /**
     * @Title: getDetail4Wechat
     * @Description:微信端获取个人报名详情
     * @throws PermissionException
     * @throws BizException
     * @throws JsonParseException
     */
    @ApiOperation(value = "微信端获取个人报名详情", httpMethod = "GET")
    @ApiImplicitParam(name = "adId", value = "广告id", dataType = "long", paramType = "query")
    @RequestMapping(value = "/getDetail4Wechat", method = RequestMethod.GET)
    ResponseDto<?> getDetail4Wechat(@CookieValue("userInfo") String userInfo, @RequestParam(value = "adId") Long adId)
            throws PermissionException, BizException, JsonParseException;

    /**
     * @Description:导出报名信息-广告位
     * @return
     * @throws PermissionException
     * @throws BizException
     * @throws JsonParseException
     */
    @ApiOperation(value = "导出报名信息", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "adId", value = "广告位id", required = false, dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "qrcodeId", value = "群二维码id", required = false, dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "statisMonth", value = "月份", required = false, dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "bookId", value = "bookId", required = false, dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "adviserId", value = "adviserId", required = false, dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "channelId", required = false, dataType = "Long", paramType = "query")
    })
    @RequestMapping(value = "/exportRegisterInfoByAdId", method = RequestMethod.GET)
    ResponseDto<Map<String, Object>> exportRegisterInfoByAdId(
            @RequestHeader("token") String token, @RequestParam("adId") Long adId,
            @RequestParam(value = "qrcodeId", required = false) Long qrcodeId, @RequestParam(value = "statisMonth", required = false) String statisMonth,
            @RequestParam(value = "bookId", required = false) Long bookId, @RequestParam(value = "adviserId", required = false) Long adviserId,
            @RequestParam(value = "channelId", required = false) Long channelId)
            throws PermissionException, BizException, JsonParseException;
}
