package com.pcloud.book.applet.biz.impl;

import com.pcloud.book.applet.biz.AppletRecordServeBiz;
import com.pcloud.book.applet.dao.AppletRecordServeDao;
import com.pcloud.book.applet.entity.AppletRecordServe;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * (AppletRecordServe)表服务实现类
 *
 * @author makejava
 * @since 2020-12-09 16:04:33
 */
@Service("appletRecordServeBiz")
public class AppletRecordServeBizImpl implements AppletRecordServeBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(AppletRecordServeBizImpl.class);

    @Autowired
    private AppletRecordServeDao appletRecordServeDao;

    @Override
    @ParamLog("通过ID查询单条数据")
    public AppletRecordServe getById(Long id) {
        return appletRecordServeDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = appletRecordServeDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)) {
            return pageBeanNew;
        }
        // 加载其它数据

        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public Long insert(AppletRecordServe appletRecordServe) {
        appletRecordServeDao.insert(appletRecordServe);
        return appletRecordServe.getId();
    }

    @Override
    @ParamLog("修改")
    public void update(AppletRecordServe appletRecordServe) {
        if (appletRecordServe == null || !NumberUtil.isNumber(appletRecordServe.getId())) {
            throw BizException.PARAM_IS_NULL;
        }
        appletRecordServeDao.update(appletRecordServe);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long id) {
        appletRecordServeDao.deleteById(id);
    }

    @Override
    public List<AppletRecordServe> getUserRecordListByType(Long wechatUserId, Integer recordType) {
        List<AppletRecordServe> appletRecordServes = appletRecordServeDao.getUserRecordListByType(wechatUserId, recordType);
        if (ListUtils.isEmpty(appletRecordServes)) {
            appletRecordServes = new ArrayList<>();
        }
        return appletRecordServes;
    }
}