package com.pcloud.book.book.biz;

import com.pcloud.book.book.entity.BookLabel;
import com.pcloud.book.book.entity.BookLabelTrim;
import com.pcloud.book.book.entity.BookLabelTrimRelate;
import com.pcloud.book.book.vo.BookLabelVO;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;
import java.util.Map;

public interface BookLabelBiz {

    /**
     * 申请新增标签
     * @param bookLabel
     * @param systemCode
     */
    void applyBookLabel(BookLabel bookLabel, String systemCode);

    /**
     * 书刊标签审核
     */
    void auditBookLabel(BookLabelVO bookLabelVO);

    /**
     * 标签删除
     * @param labelId
     */
    void deleteById(Long labelId);

    /**
     * 修改排序值
     * @param labelId
     * @param seq
     */
    void updateLabelSeq(Long labelId, Integer seq);

    /**
     * 审核通过的标签列表
     * @param labelType
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<BookLabelVO> listAuditPassBookLabel(Integer labelType, Integer currentPage, Integer numPerPage);

    /**
     * 标签管理列表
     * @param labelType
     * @param currentPage
     * @param numPerPage
     * @param name
     * @param startTime
     * @param endTime
     * @return
     */
    PageBeanNew<BookLabelVO> listApplyBookLabel(Integer labelType, Integer currentPage, Integer numPerPage,
                                                String name, String startTime, String endTime, Integer auditState);

    Map<Long,String> getLabelMapByIds(List<Long> labelIds);

    /**
     * 查标签列表
     * @author：zhuyajie
     * @date：2020/11/23 16:03
     *  * @param null
     */
    List<BookLabelVO> getLabelByIds(List<Long> labelIds);

    /**
     * 根据类型获取已经通过审核的标签
     * @param labelType
     * @return
     */
    List<BookLabel> getBookLabelsByType(Integer labelType);


    /**
     * 添加书刊新标签
     * @author：zhuyajie
     * @date：2021/8/5 16:47
     *  * @param null
     */
    void addBookNewLabel(List<Long> bookIds);

    /**
     * 查标签
     * @author：zhuyajie
     * @date：2021/7/27 14:44
     *  * @param null
     */
    Map<Long, BookLabelTrimRelate> mapBookTrimLabel(List<Long> bookIds);

    /**
     * 整理后的标签
     * @author：zhuyajie
     * @date：2021/7/27 15:46
     *  * @param null
     */
    List<BookLabelTrim> getBookLabelTrimList(Integer type);

    /**
     * 更新昨日修改过的书刊的标签
     * @author：zhuyajie
     * @date：2021/8/5 16:53
     *  * @param null
     */
    void updateYesterdayBookNewLabel();
}
