package com.pcloud.book.copyright.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author lily
 * @date 2018/12/4 11:50
 */
@Data
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BookAuthInfoVO implements Serializable {

    @ApiModelProperty("图书授权信息标识")
    private Long id;

    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("运营标识")
    private Long channelId;

    @ApiModelProperty("编辑标识")
    private Long adviserId;

    @ApiModelProperty("价格")
    private BigDecimal price;

    @ApiModelProperty("编码可使用次数")
    private Integer codeUseCount;

    @ApiModelProperty("购买链接地址")
    private String buyUrl;

    @ApiModelProperty("图书状态")
    private Integer bookStatus;

    @ApiModelProperty("验证类型")
    private Integer checkType;

    @ApiModelProperty("位置描述")
    private String locationDesc;

    @ApiModelProperty("授权后仍需付费")
    private Integer isAuthorizedPay;

    @ApiModelProperty("打开支付功能；0：关闭；1：开启；")
    private Integer openPay;

}
