package com.pcloud.book.group.dto;

import com.pcloud.book.group.entity.BookGroupServe;
import com.pcloud.common.dto.BaseDto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @ClassName com.pcloud.book.group.dto.BookGroupSceneDTO
 * @Author zhuyajie
 * @Description 社群码对应的公众号码
 * @Date 2020/12/7 10:51
 * @Version 1.0
 **/
@Data
public class BookGroupSceneDTO extends BaseDto {

    @ApiModelProperty("社群书id")
    private Long bookGroupId;
    @ApiModelProperty("编辑id")
    private Long adviserId;
    @ApiModelProperty("渠道id")
    private Long channelId;
    @ApiModelProperty("公众号二维码id")
    private Long sceneId;
    @ApiModelProperty("书刊id")
    private Long bookId;
    @ApiModelProperty("出版id")
    private String agentName;
    @ApiModelProperty("公众号二维码")
    private String qrcodeUrl;
    @ApiModelProperty("书名")
    private String bookName;
    @ApiModelProperty("公众号服务分类列表")
    private List<Integer> mpServices;
    @ApiModelProperty("公众号配置的资源")
    private List<BookGroupServe> bookServices;
    @ApiModelProperty("本书服务资源")
    private List<BookServeDTO> bookServeDTOS;
}
