package com.pcloud.book.book.service;

import com.pcloud.book.book.dto.BookAppDto;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 图书应用
 *
 * @version 1.0
 * @author:lili
 * @date 创建时间：2017年3月21日 上午11:34:18
 * @return
 */
@FeignClient(value = "pcloud-service-book", qualifiers = "bookAppServiceCloud", path = "book/v1.0/bookAppService")
@Api(description = "图书应用内部服务")
public interface BookAppService {

    /**
     * 获取图书关联应用
     *
     * @param bookId
     * @param channelId
     * @return
     */

    @ApiOperation(value = "获取图书关联应用", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "adviserId", value = "编辑标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "/listBookApp", method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<Map<Long, BookAppDto>>> listBookApp(
            @RequestParam(value = "bookId", required = false) Long bookId,
            @RequestParam(value = "channelId", required = false) Long channelId,
            @RequestParam(value = "adviserId", required = false) Long adviserId);

    /**
     * 批量添加书籍和应用关联关系
     *
     * @param bookIds
     * @param channelId
     * @param appId
     * @param adviserId
     * @throws BizException
     */
    @ApiOperation(value = "批量添加书籍和应用关联关系", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookIds", value = "图书id集合", dataType = "List<Long>", paramType = "body"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "appId", value = "应用标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "adviserId", value = "编辑标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "/createBatch", method = RequestMethod.POST)
    public void createBatch(@RequestBody(required = false) List<Long> bookIds,
                            @RequestParam(value = "channelId", required = false) Long channelId,
                            @RequestParam(value = "appId", required = false) Long appId,
                            @RequestParam(value = "adviserId", required = false) Long adviserId) throws BizException;
}
