package com.pcloud.book.guide.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@ApiModel(description = "机器人唤醒配置")
public class RobotWakeUpConfigVO {

    @ApiModelProperty("唤醒id")
    private Integer wakeUpId;

    @ApiModelProperty("开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    @ApiModelProperty("间隔时间 单位小时")
    private Integer cycle;

    @ApiModelProperty("静默时长")
    private Integer lastDay;

    @ApiModelProperty("分类ID列表")
    private List<Integer> classifyList;

    @ApiModelProperty("回复消息列表")
    private List<RobotWakeUpMsgVO> msgVOList;

}
