package com.pcloud.book.timesscreen.service;

import com.pcloud.book.book.dto.BookCountDto;
import com.pcloud.book.book.dto.BookTypeDto;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@FeignClient(value = "pcloud-service-book", qualifiers = "timesBookServiceCloud", path = "book/v1.0/timesBookService")
@Api(description = "时代大屏内部服务")
public interface TimesBookService {

    @PostMapping("getBookCount")
    @ApiOperation(value = "出版社下编辑的所有书刊的数目", httpMethod = "POST")
    ResponseEntity<ResponseDto<Integer>> getBookCount(@RequestBody List<Long> agentIds);

    @PostMapping("listBookCountByDate4Agent")
    @ApiOperation(value = "出版每日新增书刊数(2周)", httpMethod = "POST")
    ResponseEntity<ResponseDto<List<BookCountDto>>> listBookCountByDate4Agent(@RequestBody List<Long> agentIds);

    @GetMapping("listPageIncomeDetail")
    @ApiOperation(value = "数据分析 书刊分析列表", httpMethod = "GET")
    ResponseEntity<ResponseDto<PageBeanNew>> listPageIncomeDetail(@RequestParam(value = "agentId") Long agentId,
                                                                  @RequestParam(value = "keyWord", required = false) String keyWord,
                                                                  @RequestParam(value = "channelId", required = false) Long channelId,
                                                                  @RequestParam(value = "typeCode", required = false) String typeCode,
                                                                  @RequestParam(value = "currentPage") Integer currentPage,
                                                                  @RequestParam(value = "numPerPage") Integer numPerPage,
                                                                  @RequestParam(value = "isFundSupport", required = false) Integer isFundSupport,
                                                                  @RequestParam(value = "templetId", required = false) Long templetId,
                                                                  @RequestParam(value = "secondTempletId", required = false) Long secondTempletId,
                                                                  @RequestParam(value = "thirdTempletId", required = false) Long thirdTempletId);

    @GetMapping("exportBookIncomeDetail")
    @ApiOperation(value = "书刊分析 导出书刊收益列表", httpMethod = "GET")
    ResponseEntity<ResponseDto<Map<String,Object>>> exportBookIncomeDetail(@RequestParam(value = "agentId") Long agentId,
                                                                           @RequestParam(value = "keyWord", required = false) String keyWord,
                                                                           @RequestParam(value = "channelId", required = false) Long channelId,
                                                                           @RequestParam(value = "typeCode", required = false) String typeCode,
                                                                           @RequestParam(value = "isFundSupport", required = false) Integer isFundSupport,
                                                                           @RequestParam(value = "templetId", required = false) Long templetId,
                                                                           @RequestParam(value = "secondTempletId", required = false) Long secondTempletId,
                                                                           @RequestParam(value = "thirdTempletId", required = false) Long thirdTempletId);


    @ApiOperation("获取个人号累计加好友人数")
    @PostMapping("getAddFriendCount4Times")
    ResponseEntity<ResponseDto<Integer>> getAddFriendCount4Times(@RequestBody List<Long> agentIds);

    @ApiOperation("获取出版社下个人号累计加好友")
    @PostMapping("getWxUserInAgents")
    ResponseEntity<ResponseDto<List<String>>> getWxUserInAgents(@RequestBody List<Long> agentIds);

    @ApiOperation("获取出版社下社群")
    @PostMapping("getBookGroupIdInAgents")
    ResponseEntity<ResponseDto<List<Long>>> getBookGroupIdInAgents(@RequestBody List<Long> agentIds);

    @ApiOperation("获取书籍类型列表")
    @GetMapping("list")
    ResponseEntity<ResponseDto<List<BookTypeDto>>> list();


}
