package com.pcloud.book.applet.biz.impl;

import com.pcloud.book.applet.biz.AppletResourceApplyBiz;
import com.pcloud.book.applet.contants.AppletResourceApplyConstants;
import com.pcloud.book.applet.dao.AppletResourceApplyDao;
import com.pcloud.book.applet.dto.AddResourceApplyDTO;
import com.pcloud.book.applet.entity.AppletResourceApply;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.string.StringUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @ClassName com.pcloud.book.applet.biz.impl.AppletResourceApplyBizImpl
 * @Author zhuyajie
 * @Description 资源适用范围
 * @Date 2021/5/8 15:12
 * @Version 1.0
 **/
@Component
public class AppletResourceApplyBizImpl implements AppletResourceApplyBiz {

    @Autowired
    private AppletResourceApplyDao appletResourceApplyDao;

    @Override
    public void addResourceApply(AddResourceApplyDTO addResourceApplyDTO) {
        if (null == addResourceApplyDTO || null == addResourceApplyDTO.getTargetId() || StringUtil.isEmpty(addResourceApplyDTO.getTargetType())) {
            return;
        }
        Long targetId = addResourceApplyDTO.getTargetId();
        String targetType = addResourceApplyDTO.getTargetType();
        appletResourceApplyDao.deleteCrowdType(targetId, targetType);
        appletResourceApplyDao.deleteContentType(targetId, targetType);
        if (!ListUtils.isEmpty(addResourceApplyDTO.getCrowdTypeList())) {
            List<AppletResourceApply> crowdList = new ArrayList<>();
            for (Integer crowdType : addResourceApplyDTO.getCrowdTypeList()) {
                AppletResourceApply apply = new AppletResourceApply();
                apply.setTargetId(targetId);
                apply.setTargetType(targetType);
                apply.setCrowdType(crowdType);
                crowdList.add(apply);
            }
            appletResourceApplyDao.insert(crowdList);
        }
        if (!ListUtils.isEmpty(addResourceApplyDTO.getContentTypeList())) {
            List<AppletResourceApply> contentList = new ArrayList<>();
            for (Integer contentType : addResourceApplyDTO.getContentTypeList()) {
                AppletResourceApply apply = new AppletResourceApply();
                apply.setTargetId(targetId);
                apply.setTargetType(targetType);
                apply.setContentType(contentType);
                contentList.add(apply);
            }
            appletResourceApplyDao.insert(contentList);
        }
    }

    @Override
    public List<Integer> getCrowdTypeList(Long targetId, String targetType) {
        return appletResourceApplyDao.getCrowdTypeList(targetId, targetType);
    }

    @Override
    public List<Integer> getContentTypeList(Long targetId, String targetType) {
        return appletResourceApplyDao.getContentTypeList(targetId, targetType);
    }
}
