package com.pcloud.book.applet.dao;

import com.pcloud.book.applet.entity.AppletNewsPool;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

public interface AppletNewsPoolDAO extends BaseDao<AppletNewsPool> {
    /**
     * 有选择性的更新资讯
     * @param appletNewsPool
     */
    void updateSelective(AppletNewsPool appletNewsPool);

    /**
     * 资讯池批量删除
     * @param ids
     */
    void batchDelete(List<Long> ids);

    /**
     * 资讯来源列表
     * @return
     */
    List<String> listSource();

    /**
     * 根据id列表获取map
     * @param appletNewsPoolIds
     * @return
     */
    Map<Long, AppletNewsPool> getMapByIds(List<Long> appletNewsPoolIds);
}
