package com.pcloud.book.applet.dao.impl;

import cn.hutool.core.map.MapUtil;
import com.pcloud.book.applet.dao.AppletRecordDao;
import com.pcloud.book.applet.dto.AppletAppOrProductDTO;
import com.pcloud.book.applet.dto.AppletRecordBookDTO;
import com.pcloud.book.applet.dto.AppletRecordDTO;
import com.pcloud.book.applet.dto.AppletUserBookcaseDTO;
import com.pcloud.book.applet.dto.ReadBookDayStatisDTO;
import com.pcloud.book.applet.entity.AppletRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.apache.ibatis.session.ResultHandler;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * (AppletRecord)表数据库访问层
 *
 * @author makejava
 * @since 2020-08-27 15:49:56
 */
@Repository("appletRecordDaoImpl")
public class AppletRecordDaoImpl extends BaseDaoImpl<AppletRecord> implements AppletRecordDao {

    @Override
    public Map<Long, AppletUserBookcaseDTO> getBookMap(List<AppletRecordDTO> appletRecordDTOS4Book) {
        return getSessionTemplate().selectMap(getStatement("getBookMap"), appletRecordDTOS4Book, "id");
    }

    @Override
    public void updateDeleteState(Long fromId, Integer recordType) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("fromId", fromId);
        paramMap.put("recordType", recordType);
        getSessionTemplate().update(getStatement("updateDeleteState"), paramMap);
    }

    @Override
    public List<Date> listReachableDate(Long wechatUserId) {
        return getSqlSession().selectList("listReachableDate", MapUtil.of("wechatUserId",wechatUserId));
    }

    @Override
    public List<ReadBookDayStatisDTO> getReadBookWeekStatis(Long wechatUserId, String mondayDate, String sundayDate) {
        HashMap<String,Object> paramMap = new HashMap<>();
        paramMap.put("wechatUserId", wechatUserId);
        paramMap.put("mondayDate", mondayDate);
        paramMap.put("sundayDate", sundayDate);
        return this.sqlSessionTemplate.selectList(getStatement("getReadBookWeekStatis"),paramMap);
    }

    @Override
    public List<AppletRecordBookDTO> getBooksByWechatUserId(Long wechatUserId) {
        HashMap<String,Object> paramMap = new HashMap<>();
        paramMap.put("wechatUserId", wechatUserId);
        return this.sqlSessionTemplate.selectList(getStatement("getBooksByWechatUserId"),paramMap);
    }

    @Override
    public Long getStatisUserCount(Date prevMonday, Date prevSunday) {
        HashMap<String,Object> paramMap = new HashMap<>();
        paramMap.put("prevMonday", prevMonday);
        paramMap.put("prevSunday", prevSunday);
        return this.sqlSessionTemplate.selectOne(getStatement("getStatisUserCount"), paramMap);
    }

    @Override
    public Map<Long, AppletAppOrProductDTO> getAppOrProductBrowseCount(Integer recordType, List<Long> serveIds) {
        HashMap<String,Object> paramMap = new HashMap<>();
        paramMap.put("recordType", recordType);
        paramMap.put("serveIds", serveIds);
        return this.sqlSessionTemplate.selectMap(getStatement("getAppOrProductBrowseCount"), paramMap, "serveId");
    }

    @Override
    public void fixAppletRecordDataSync4CH(String createDate, ResultHandler<AppletRecord> handler) {
        Map<String, Object> params = MapUtil.<String, Object>builder().put("createDate", createDate).build();
        getSqlSession().select(getStatement("fixAppletRecordDataSync4CH"), params, handler);
    }

    @Override
    public List<AppletRecordDTO> getHandleAppletRecordTypeCode(Map<String, Object> paramMap) {
        return getSqlSession().selectList(getStatement("getHandleAppletRecordTypeCode"), paramMap);
    }

    @Override
    public void batchUpdateTypeCode(List<AppletRecordDTO> recordList) {
        getSqlSession().update(getStatement("batchUpdateTypeCode"), recordList);
    }
}
