package com.pcloud.book.applet.entity;

import java.util.Date;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 学舍群管理(AppletGroupManage)实体类
 *
 * @author zyq
 * @since 2020-04-01 14:05:37
 */
@Data
public class AppletGroupManage extends BaseEntity {

    private static final long serialVersionUID = 756856688436151148L;
    
    private Long id;
    
    @ApiModelProperty("共读活动id")
    private Long groupActivityId;
    
    @ApiModelProperty("上架")
    private Integer enable;
    
    @ApiModelProperty("推荐到首页")
    private Integer recommend;

    @ApiModelProperty("序号")
    private Integer seqNum;
    
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("出版社id")
    private Long agentId;
}