/**
 * 
 */
package com.pcloud.book.book.dao;

import com.pcloud.book.book.dto.AdviserBookInfoDTO;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.book.dto.BookInfo4AnlysicsDTO;
import com.pcloud.book.book.dto.BookInfoAnalysicsDTO;
import com.pcloud.book.book.entity.Book;
import com.pcloud.book.book.vo.BookSaleVO;
import com.pcloud.book.book.vo.SearchBookVO;
import com.pcloud.book.book.dto.BookUniqueNumberDTO;
import com.pcloud.book.es.entity.ESBookAndAdviser;
import com.pcloud.common.core.dao.BaseDao;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.page.PageParam;

import java.util.List;
import java.util.Map;

/**
 * @描述：书籍数据访问层接口
 * @作者：songx
 * @创建时间：2016年12月23日,下午2:57:21 @版本：1.0
 */
public interface BookDao extends BaseDao<Book> {

	/**
	 * 批量删除书籍
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @param deleteUserId
	 *            删除的用户标识
	 * @return
	 */
	Integer deleteByIds(List<Long> bookIds, Long deleteUserId);

	/**
	 * 获取书籍基础信息
	 * 
	 * @param bookId
	 *            图书标识
	 * @return
	 */
	BookDto getBaseById(Long bookId);

	/**
	 * 根据ISBN和图书序号获取图书信息（包含删除图书数据）
	 * 
	 * @param isbn
	 *            isbn号
	 * @param serialNumber
	 *            序列号
	 * @return
	 */
	BookDto getByIsbnAndSnumContainsDelete(String isbn, String serialNumber);

	/**
	 * 根据ISBN获取书刊信息（包含删除图书数据）
	 * 
	 * @param isbn
	 * @return
	 */
	BookDto getByIsbn(String isbn);

	/**
	 * 获取单个书籍基础信息(包含统计信息)
	 * 
	 * @param paramMap
	 * @return
	 */
	BookDto getById(Map<String, Object> paramMap);

	/**
	 * 批量获取书籍信息
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @return
	 */
	Map<Long, BookDto> getMapByIds(List<Long> bookIds);

	/**
	 * 批量获取书籍信息（书名 与书刊序号 封面图）
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @return
	 */
	Map<Long, BookDto> listBaseMapByIds(List<Long> bookIds);

	/**
	 * 批量获取书籍信息
	 *
	 * @param bookIds
	 * @param channelIds
	 * @param adviserIds
	 * @return
	 */
	List<BookDto> listBookGroupByBookIds(List<Long>bookIds,List<Long>channelIds,List<Long>adviserIds);

	/**
	 * 获取详细信息
	 * @param paramMap
	 * @return
	 */
	List<BookDto> listDetailByIds(Map<String,Object> paramMap);

	/**
	 * 根据名称获取ID
	 * 
	 * @param bookName
	 *            图书名称
	 * @return
	 */
	List<Long> getIdsByName(String bookName);
	
	/**
	 * 根据名称获取ID
	 * 
	 * @param paramMap
	 *            图书名称
	 * @return
	 */
	List<Long> getIdsByNameMap(Map<String, Object> paramMap);

	/**
	 * 图书收益，获取书籍列表(编辑)
	 * 
	 * @param paramMap
	 * @return
	 */
	List<BookDto> getList4AdviserProfit(Map<String, Object> paramMap);

	/**
	 * 根据刊物序号获取刊物信息
	 * 
	 * @param serialNumber
	 *            刊物序号
	 * @return BookDto
	 */
	BookDto getBySerialNum(String serialNumber);

	// /**
	// * 根据ISSN获取期刊基本信息
	// *
	// * @param isbn
	// * @return
	// */
	// BookDto getByJournIsbn(String isbn);

	/**
	 * 获取书籍详细信息（包含书籍关联二维码 商品 应用）
	 * 
	 * @param paramMap
	 * @return
	 */
	BookDto getDetailByIsbn(Map<String, Object> paramMap);

	/**
	 * @Title: getListPage
	 * @Description:获取书刊列表
	 * @param paramMap
	 * @return: List<BookDto>
	 * @author: lihao
	 * @date: 2017年7月26日 上午10:47:01
	 */
	List<BookDto> getListPage4Platform(Map<String, Object> paramMap);

	/**
	 * @Title: 获取书籍总数
	 * @Description:获取书籍总数
	 * @return: Integer
	 * @author: lihao
	 * @date: 2017年7月26日 上午11:58:34
	 */
	int getAllBookCount();

	/**
	 * @Title: getBookCount4Platform
	 * @Description:条件查询获取书籍总数
	 * @param paramMap
	 * @return: int
	 * @author: lihao
	 * @date: 2017年7月26日 下午12:36:07
	 */
	int getBookCount4Platform(Map<String, Object> paramMap);

	/**
	 * 修改书籍封面图
	 * 
	 * @param book
	 *            图书实体
	 */
	void updateCoverImg(Book book);

	/**
	 * 获取应用关联图书
	 * 
	 * @param paramMap
	 * @return
	 */
	List<BookDto> listBookByAppId(Map<String, Object> paramMap);

	/**
	 * 删除图书
	 * 
	 * @param bookId
	 *            图书标识
	 * @param deleteUserId
	 *            删除的用户标识
	 * @return
	 */
	Integer deleteBook(Long bookId, Long deleteUserId);

	/**
	 * 获取出版下除默认生成图书的所有图书总数
	 * 
	 * @param param
	 * @return
	 */
	Integer getAllBookCount4Agent(Map<String, Object> param);

	/**
	 * 获取isbn对应图书信息
	 * 
	 * @param isbn
	 * @return
	 */
	Map<Long, BookDto> listByIsbn(String isbn);

	/**
	 * 获取图书总数除RAYS现代纸书
	 * 
	 * @param param
	 * @return
	 */
	Integer getAllBookCount4Platform(Map<String, Object> param);

	/**
	 * 获取编辑图书模板
	 * 
	 * @param adviserId
	 *            编辑标识
	 * @param channelId
	 *            渠道标识
	 * @param bookId
	 *            图书标识
	 * @return
	 */
	Long getTempletId(Long adviserId, Long channelId, Long bookId);

	/**
	 * 修改图书基本信息
	 * 
	 * @param book
	 *            图书实体
	 */
	void updateByAdviser(Book book);

	/**
	 * 根据isbn和书刊序号获取图书信息（不包含删除的图书）
	 * 
	 * @param isbn
	 * @param serialNumber
	 *            刊物序号
	 * @return
	 */
	BookDto getByIsbnAndSnum(String isbn, String serialNumber);

	/**
	 * 获取图书信息
	 * @param param
	 * @return
	 */
	List<BookDto> getList4Adviser(Map<String, Object> param);

	/**
	 * 修改时间
	 * @param param
	 */
	void updateTimeById(Map<String, Object> param);

	/**
	 * 批量修改时间
	 * @param param
	 */
	void updateTimeByIds(Map<String, Object> param);

	/**
	 * 根据条件查询书刊相关信息
	 * @param param
	 * @return
	 */
	List<BookInfoAnalysicsDTO> getBookInfoBy(Map<String, Object> param);

	/**
	 * 获取书刊信息
 	 * @param paramMap
	 * @return
	 */
	List<BookInfo4AnlysicsDTO> getBookAnalysis(Map<String,Object> paramMap);

    /**
     * 获取编辑书刊ID和运营ID列表
     * @param paramMap
     * @return
     */
    List<BookDto> listBookIdAndChannelId4Adviser(Map<String, Object> paramMap);

    /**
     * 获取社群书列表
     * @param paramMap 参数Map
     * @return
     */
    List<BookDto> listSimpleBookGroup4Adviser(Map<String, Object> paramMap);

	/**
	 *  获取社群书列表(编辑)
	 * @param paramMap
	 * @return
	 */
	List<BookDto> listBookGroup4Adviser(Map<String, Object> paramMap);

	/**
	 * 根据书名或ISBN获取书id
	 */
	List<Long> getIdsByNameOrISBN(Map<String,Object> paramMap);

	/**
	 * 查询书刊数量
	 */
	Long listBookClassifyCount(Map<String,Object> paramMap);

	List<BookSaleVO> listIncomePage4Agent(Map<String,Object> paramMap);

	Long countIncomePage4Agent(Map<String, Object> paramMap);

	/**
	 * 模糊匹配书名 限制50条
	 * @param bookName
	 * @return
	 */
	List<Long> getBookIdsByBookName(String bookName);

	BookDto getAdviserBookByName(String bookName);

	List<Long> getBookIdsByIsbn(String isbn);

	void updateBookQualifyInfo(Map<String, Object> map);

    SearchBookVO getBookInfoByBookGroupId(Map<String, Object> paramMap);

    void updateIsOpenRobotProcess(Map<String, Object> paramMap);

    Integer count();

	List<ESBookAndAdviser> findAllBookAndAdviser(Long maxId, Integer offset);

	List<ESBookAndAdviser> findBookAndAdviserByBookIds(List<Long> bookIds);

	Map<Long,BookDto> getMapByBookIds(List<Long> bookIds);

	BookDto getBookByName(String bookName);

	List<AdviserBookInfoDTO> getBookAdviserInfos(List<Long> bookIds);

    void relateUniqueNumber4Erp(List<BookUniqueNumberDTO> bookUniqueNumberVos);

	void updateByPrimaryKeySelective(Book book);

	Integer checkIsGroupBook(Long bookId);

	BookDto getBaseById4Buy(Map<String, Object> paramMap);

    List<Long> getByIds(List<Long> esBookIds);

    List<BookDto> listPageBookMinimunSupport4Platform(Map<String, Object> paramMap);

    Integer getBookMinimunSupportCount4Platform(Map<String, Object> paramMap);

    Integer getFundBookCounts(List<Long> advisers,int month);

	Integer getBookCountByAdviserId(Long adviserId);

    boolean checkIsBookId(Long isbnNumber);

	List<BookDto> listPage4Agent(Map<String, Object> paramMap);

    List<Object> getAppointBooks(Long channelId, List<Long> bookIds);

    PageBean getListPage4AdviserPageBean(PageParam pageParam, Map<String, Object> paramMap);

	List<Object> getListPage4Adviser(Map<String, Object> paramMap);

	Integer getListPage4AdviserCount(Map<String, Object> paramMap);
}
