package com.pcloud.book.book.dao.impl;

import com.pcloud.book.book.dao.BookLinkDao;
import com.pcloud.book.book.entity.BookLink;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.book.dao.impl.BookLinkDaoImpl
 * @Author zhuyajie
 * @Description 书刊链接
 * @Date 2021/4/1 9:59
 * @Version 1.0
 **/
@Repository
public class BookLinkDaoImpl extends BaseDaoImpl<BookLink> implements BookLinkDao {
    @Override
    public BookLink getByBookIdAndAdviser(Long bookId, Long adviserId) {
        Map<String, Object> map = new HashMap<>();
        map.put("createUser", adviserId);
        map.put("bookId", bookId);
        return getSessionTemplate().selectOne(getStatement("getByBookIdAndAdviser"), map);
    }

    @Override
    public Map<Long, BookLink> getBookLinkMap(Long adviserId, List<Long> bookIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("createUser", adviserId);
        map.put("bookIds", bookIds);
        return getSessionTemplate().selectMap(getStatement("getBookLinkMap"), map, "bookId");
    }
}
