package com.pcloud.book.book.dao.impl;

import com.pcloud.book.book.dao.SearchRecordDisDao;
import com.pcloud.book.book.entity.SearchRecordDis;
import com.pcloud.book.book.vo.SearchBookVO;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("searchRecordDisDao")
public class SearchRecordDisDaoImpl extends BaseDaoImpl<SearchRecordDis> implements SearchRecordDisDao {

    @Override
    public SearchRecordDis getByCondition(Long wechatUserId, String wxId, String content) {
        Map<String,Object> map=new HashMap<>();
        map.put("wechatUserId",wechatUserId);
        map.put("wxId",wxId);
        map.put("content",content);
        return super.getSqlSession().selectOne(super.getStatement("getByCondition"),map);
    }

    @Override
    public void updateUserDeleteByWxId(String wxId, Boolean userDelete) {
        Map<String,Object> map=new HashMap<>();
        map.put("wxId",wxId);
        map.put("userDelete",userDelete);
        super.getSqlSession().update(super.getStatement("updateUserDeleteByWxId"),map);
    }

    @Override
    public void updateUserDeleteByWechatUserId(Long wechatUserId, Boolean userDelete) {
        Map<String,Object> map=new HashMap<>();
        map.put("wechatUserId",wechatUserId);
        map.put("userDelete",userDelete);
        super.getSqlSession().update(super.getStatement("updateUserDeleteByWechatUserId"),map);
    }

    @Override
    public Map<String, SearchRecordDis> getSearchMap(List<String> searchContentList) {
        return getSessionTemplate().selectMap(getStatement("getSearchMap"), searchContentList, "content");
    }
}
