package com.pcloud.book.consumer.promotion;

import cn.hutool.core.collection.CollUtil;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.promotion.couponsnew.dto.CouponMapRequestDto;
import com.pcloud.promotion.couponsnew.dto.CouponsNewDto;
import com.pcloud.promotion.couponsnew.service.CouponsNewService;
import com.pcloud.promotion.fission.dto.UpdateQrDTO;
import com.pcloud.promotion.groupFission.service.GroupFissionService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("promotionConsr")
public class PromotionConsr {
    /**
     * logger
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(PromotionConsr.class);


    @Autowired
    private GroupFissionService groupFissionService;
    @Autowired
    private CouponsNewService couponsNewService;

    @ParamLog("获取备用二维码")
    public String getSpareQr() throws BizException {
        try {
            return ResponseHandleUtil.parseResponse(groupFissionService.getSpareQr(), String.class);
        } catch (Exception e) {
            LOGGER.warn("获取备用二维码失败:" + e.getMessage(), e);
        }
        return "";
    }

    @ParamLog("同步更新二维码")
    public void updateQrUrl(UpdateQrDTO updateQrDTO) throws BizException {
        try {
            groupFissionService.updateQrUrl(updateQrDTO);
        } catch (Exception e) {
            LOGGER.warn("同步更新二维码失败:" + e.getMessage(), e);
        }
    }

    @ParamLog("获取优惠券信息")
    public Map<Long, CouponsNewDto> mapByCouponIds(List<Long> couponsIds, Long wechatUserId) throws BizException {
        if(CollUtil.isEmpty(couponsIds)){
            return new HashMap<>();
        }
        try {
            CouponMapRequestDto dto = new CouponMapRequestDto();
            dto.setCouponIds(couponsIds);
            dto.setWechatUserId(wechatUserId);
            return ResponseHandleUtil.parseMap(couponsNewService.mapByCouponIds(dto), Long.class, CouponsNewDto.class);
        } catch (Exception e) {
            LOGGER.warn("同步更新二维码失败:" + e.getMessage(), e);
        }
        return new HashMap<>();
    }
}
