package com.pcloud.book.copyright.biz.impl;

import com.pcloud.book.base.enums.BookStatusEnum;
import com.pcloud.book.book.biz.BookBiz;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.consumer.message.TemplateConsr;
import com.pcloud.book.consumer.reader.ReaderConsr;
import com.pcloud.book.copyright.biz.BookAuthOrderBiz;
import com.pcloud.book.copyright.biz.BookAuthUserBiz;
import com.pcloud.book.copyright.dao.BookAuthOrderDao;
import com.pcloud.book.copyright.entity.BookAuthOrder;
import com.pcloud.book.copyright.entity.BookAuthUser;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.SceneCode;
import com.pcloud.common.core.constant.SendType;
import com.pcloud.common.utils.string.StringUtil;
import com.pcloud.facade.tradecenter.entity.Genuine;
import com.pcloud.readercenter.wechat.entity.WechatUser;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lily
 * @date 2018/12/5 10:35
 */
@Component("bookAuthOrderBiz")
public class BookAuthOrderBizImpl implements BookAuthOrderBiz {

    @Autowired
    private BookAuthOrderDao bookAuthOrderDao;
    @Autowired
    private BookAuthUserBiz bookAuthUserBiz;
    @Autowired
    private TemplateConsr templateConsr;
    @Autowired
    private BookBiz bookBiz;
    @Autowired
    private ReaderConsr readerConsr;

    @Override
    @ParamLog("新增授权金购买订单")
    @Transactional(rollbackFor = Exception.class)
    public void insertOrder(Genuine genuine) {
        if (genuine == null) return;
        BookAuthOrder bookAuthOrder = new BookAuthOrder();
        BeanUtils.copyProperties(genuine, bookAuthOrder);
        bookAuthOrder.setMoney(genuine.getMoney());
        bookAuthOrder.setAccountSettingId(genuine.getOfficialAccountId());
        bookAuthOrder.setOrderNum(genuine.getOrderFormMainId().toString());
        if(genuine.getIsGroupBook() != null && genuine.getIsGroupBook() .equals(1)) {
            bookAuthOrder.setIsGroupBook(1);
            bookAuthOrder.setIsPaperBook(0);
        } else {
            bookAuthOrder.setIsGroupBook(0);
            bookAuthOrder.setIsPaperBook(1);
        }
        bookAuthOrderDao.insert(bookAuthOrder);
        //新增用户授权记录
        BookAuthUser bookAuthUser = new BookAuthUser();
        BeanUtils.copyProperties(bookAuthOrder, bookAuthUser);
        bookAuthUser.setAuthCode(BookStatusEnum.AuthCodeTypeEnum.BY_PAY.value);
        WechatUser wechatUser = readerConsr.getWechatUser(genuine.getWechatUserId());
        bookAuthUser.setProvince(wechatUser == null || StringUtil.isEmpty(wechatUser.getWechatUserProvince()) ? "未知" : wechatUser.getWechatUserProvince());
        bookAuthUser.setCity(wechatUser == null || StringUtil.isEmpty(wechatUser.getWechatUserCity()) ? "未知" : wechatUser.getWechatUserCity());
        bookAuthUserBiz.insert(bookAuthUser);
        BookDto bookDto = bookBiz.getBaseById(genuine.getBookId());
        //发送模板消息
        Map<String, String> paramMap = new HashMap<>();
        paramMap.put("first", "正版授权成功");
        paramMap.put("keyword1", genuine.getMoney() == null ? "" : genuine.getMoney().toString());
        paramMap.put("keyword2", bookDto == null ? "" : StringUtil.addBracket(bookDto.getBookName()) + "正版授权费");
        paramMap.put("Remark", "支持正版图书，享受专属资源");
        String  url = "/C" + genuine.getChannelId() + "/qrcode/" + genuine.getSceneId() + "?adviserId=" + genuine.getAdviserId() + "&sceneId=" + genuine.getSceneId() + "&source_type=QRCODE";
        templateConsr.sendOperate(SceneCode.PAY_SUCCESS_SCENE.value, genuine.getChannelId(), genuine.getWechatUserId(), url, paramMap, SendType.SEND_BY_WECHAT_USER_ID.value, false);
    }
}
