package com.pcloud.book.copyright.dao;

import com.pcloud.book.copyright.dto.BookAuthCodeDTO;
import com.pcloud.book.copyright.dto.SceneAuthCodeResponseDTO;
import com.pcloud.book.copyright.entity.BookSceneAuthCode;
import com.pcloud.common.core.dao.BaseDao;
import java.util.List;
import java.util.Map;

/**
 * 书籍二维码授权码记录表(BookSceneAuthCode)表数据库访问层
 *
 * @author makejava
 * @since 2021-10-19 14:14:47
 */
public interface BookSceneAuthCodeDao extends BaseDao<BookSceneAuthCode> {

    Integer getMaxBatchNum(Long bookId, Long channelId,Long sceneId, Long adviserId, Integer authBookType);

    void deleteSceneAuthCode(List<Long> ids);

    List<Long> getCodeIdList(Long bookId, Long channelId, Long adviserId, String keyWord, Integer authBookType, Long sceneId);

    BookSceneAuthCode getByCode(String code);

    void updateUseCount(Long id);

    List<SceneAuthCodeResponseDTO> getCodeCount(Long bookId, List<Long> sceneIds);

    void batchUpdate(List<BookSceneAuthCode> list);

    List<BookAuthCodeDTO> getBookSceneAuthCodeList(Map<String, Object> paramMap);
}